/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.ElementalCraft;

@Mod.EventBusSubscriber(modid="elementalcraft")
public final class LootHandler {
    private static final List<String> BLACKLIST = ImmutableList.of((Object)"dispenser");
    public static final List<String> INJECT_lIST = ImmutableList.builder().addAll(LootHandler.getInjects(EntityType.field_200725_aD, EntityType.field_200727_aF, EntityType.field_200741_ag, EntityType.field_200722_aA, EntityType.field_200740_af, EntityType.field_200757_aw, EntityType.field_200742_ah, EntityType.field_200797_k, EntityType.field_200811_y, EntityType.field_200792_f, EntityType.field_200763_C, EntityType.field_200771_K, EntityType.field_233592_ba_, EntityType.field_233590_aW_, EntityType.field_204724_o, EntityType.field_200761_A, EntityType.field_200800_n, EntityType.field_200743_ai, EntityType.field_200750_ap, EntityType.field_200749_ao, EntityType.field_200786_Z, EntityType.field_205137_n, EntityType.field_203780_j, EntityType.field_203778_ae, EntityType.field_204262_at, EntityType.field_203779_Z, EntityType.field_200803_q, EntityType.field_200748_an, EntityType.field_200794_h, EntityType.field_203097_aH, EntityType.field_200738_ad)).build();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void lootLoad(LootTableLoadEvent evt) {
        ResourceLocation name = evt.getName();
        ResourceLocation injectName = ElementalCraft.createRL("inject/" + name.func_110623_a());
        if (INJECT_lIST.contains(name.func_110623_a())) {
            evt.getTable().addPool(LootHandler.getInjectPool(injectName));
        } else if (name.toString().startsWith("minecraft:chests/")) {
            if (BLACKLIST.stream().anyMatch(name.toString()::contains)) {
                evt.getTable().addPool(LootHandler.getInjectPool(ElementalCraft.createRL("chests/inject")));
            }
        }
    }

    public static LootPool getInjectPool(ResourceLocation name) {
        return LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)name).func_216086_a(1)).bonusRolls(0.0f, 1.0f).name("elementalcraft_inject").func_216044_b();
    }

    private static List<String> getInjects(EntityType<?> ... types) {
        return Stream.of(types).map(type -> type.func_220348_g().func_110623_a()).collect(Collectors.toList());
    }
}

