/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.material;

import java.util.function.Supplier;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.item.ECItems;

public class ECMaterials {
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    public static final Material SOURCE = new Material(MaterialColor.field_151660_b, false, false, false, false, false, true, PushReaction.DESTROY);
    public static final IItemTier TOOL_WATER = new ECItemTier(2, 250, 6.0f, 2.0f, 17, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.waterCrystal}));
    public static final IItemTier TOOL_FIRE = new ECItemTier(2, 250, 6.0f, 3.0f, 14, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.fireCrystal}));
    public static final IItemTier TOOL_EARTH = new ECItemTier(2, 500, 6.0f, 2.0f, 14, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.earthCrystal}));
    public static final IItemTier TOOL_AIR = new ECItemTier(2, 250, 7.0f, 2.0f, 14, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.airCrystal}));
    public static final IItemTier TOOL_PURE = new ECItemTier(5, 2500, 10.0f, 5.0f, 19, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.pureCrystal}));
    public static final IArmorMaterial ARMOR_WATER = new ECArmorMaterial("iron", 15, new int[]{2, 5, 6, 2}, 11, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.waterCrystal}));
    public static final IArmorMaterial ARMOR_FIRE = new ECArmorMaterial("iron", 17, new int[]{3, 5, 7, 2}, 9, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.fireCrystal}));
    public static final IArmorMaterial ARMOR_EARTH = new ECArmorMaterial("iron", 20, new int[]{2, 5, 6, 2}, 9, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.earthCrystal}));
    public static final IArmorMaterial ARMOR_AIR = new ECArmorMaterial("iron", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.field_187725_r, 1.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.airCrystal}));
    public static final IArmorMaterial ARMOR_PURE = new ECArmorMaterial("diamond", 44, new int[]{3, 6, 8, 3}, 16, SoundEvents.field_187716_o, 3.0f, 0.1f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ECItems.pureCrystal}));

    private static class ECArmorMaterial
    implements IArmorMaterial {
        private final String name;
        private final int maxDamageFactor;
        private final int[] damageReductionAmountArray;
        private final int enchantability;
        private final SoundEvent soundEvent;
        private final float toughness;
        private final LazyValue<Ingredient> repairMaterial;
        private final float knockbackResistance;

        private ECArmorMaterial(String nameIn, int maxDamageFactorIn, int[] damageReductionAmountsIn, int enchantabilityIn, SoundEvent equipSoundIn, float toughnessIn, float knockbackResistance, Supplier<Ingredient> repairMaterialSupplier) {
            this.name = nameIn;
            this.maxDamageFactor = maxDamageFactorIn;
            this.damageReductionAmountArray = damageReductionAmountsIn;
            this.enchantability = enchantabilityIn;
            this.soundEvent = equipSoundIn;
            this.toughness = toughnessIn;
            this.knockbackResistance = knockbackResistance;
            this.repairMaterial = new LazyValue(repairMaterialSupplier);
        }

        public int func_200896_a(EquipmentSlotType slotIn) {
            return MAX_DAMAGE_ARRAY[slotIn.func_188454_b()] * this.maxDamageFactor;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return this.damageReductionAmountArray[slotIn.func_188454_b()];
        }

        public int func_200900_a() {
            return this.enchantability;
        }

        public SoundEvent func_200899_b() {
            return this.soundEvent;
        }

        public Ingredient func_200898_c() {
            return (Ingredient)this.repairMaterial.func_179281_c();
        }

        @OnlyIn(value=Dist.CLIENT)
        public String func_200897_d() {
            return this.name;
        }

        public float func_200901_e() {
            return this.toughness;
        }

        public float func_230304_f_() {
            return this.knockbackResistance;
        }
    }

    private static class ECItemTier
    implements IItemTier {
        private final int harvestLevel;
        private final int maxUses;
        private final float efficiency;
        private final float attackDamage;
        private final int enchantability;
        private final LazyValue<Ingredient> repairMaterial;

        private ECItemTier(int harvestLevelIn, int maxUsesIn, float efficiencyIn, float attackDamageIn, int enchantabilityIn, Supplier<Ingredient> repairMaterialIn) {
            this.harvestLevel = harvestLevelIn;
            this.maxUses = maxUsesIn;
            this.efficiency = efficiencyIn;
            this.attackDamage = attackDamageIn;
            this.enchantability = enchantabilityIn;
            this.repairMaterial = new LazyValue(repairMaterialIn);
        }

        public int func_200926_a() {
            return this.maxUses;
        }

        public float func_200928_b() {
            return this.efficiency;
        }

        public float func_200929_c() {
            return this.attackDamage;
        }

        public int func_200925_d() {
            return this.harvestLevel;
        }

        public int func_200927_e() {
            return this.enchantability;
        }

        public Ingredient func_200924_f() {
            return (Ingredient)this.repairMaterial.func_179281_c();
        }
    }
}

