/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.binder.TileBinder;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;

public class BindingRecipe
extends AbstractInstrumentRecipe<TileBinder> {
    public static final String NAME = "binding";
    public static final IRecipeType<BindingRecipe> TYPE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)ElementalCraft.createRL("binding"), (Object)new IRecipeType<BindingRecipe>(){

        public String toString() {
            return BindingRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:binding")
    public static IRecipeSerializer<BindingRecipe> SERIALIZER;
    private NonNullList<Ingredient> ingredients;
    private ItemStack output;
    private int elementAmount;

    public BindingRecipe(ResourceLocation id, ElementType type, int elementAmount, ItemStack output, List<Ingredient> ingredients) {
        super(id, type);
        this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])((Ingredient[])ingredients.stream().toArray(Ingredient[]::new)));
        this.output = output;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public boolean matches(TileBinder inv) {
        if (inv.getTankElementType() != this.getElementType() || inv.getItemCount() != this.ingredients.size()) {
            return false;
        }
        return Boolean.TRUE.equals(ECConfig.COMMON.binderRecipeMatchOrder.get()) ? this.matchesOrdered(inv) : RecipeHelper.matchesUnordered(inv.getInventory(), this.ingredients);
    }

    private boolean matchesOrdered(TileBinder inv) {
        for (int i = 0; i < inv.getItemCount(); ++i) {
            if (((Ingredient)this.ingredients.get(i)).test(inv.getInventory().func_70301_a(i))) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    @Override
    public void process(TileBinder instrument) {
        instrument.func_174888_l();
        super.process(instrument);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BindingRecipe> {
        final IRecipeFactory factory;

        public Serializer(IRecipeFactory factory) {
            this.factory = factory;
        }

        public BindingRecipe read(ResourceLocation recipeId, JsonObject json) {
            ElementType type = ElementType.byName(JSONUtils.func_151200_h((JsonObject)json, (String)"element_type"));
            int elementAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = RecipeHelper.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            ItemStack output = RecipeHelper.readRecipeOutput(JSONUtils.func_151200_h((JsonObject)json, (String)"output"));
            return this.factory.create(recipeId, type, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public BindingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ElementType type = ElementType.byName(buffer.func_150789_c(Short.MAX_VALUE));
            int elementAmount = buffer.readInt();
            ItemStack output = buffer.func_150791_c();
            int i = buffer.func_150792_a();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return this.factory.create(recipeId, type, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public void write(PacketBuffer buffer, BindingRecipe recipe) {
            buffer.func_180714_a(recipe.getElementType().func_176610_l());
            buffer.writeInt(recipe.getElementAmount());
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
        }

        public static interface IRecipeFactory {
            public BindingRecipe create(ResourceLocation var1, ElementType var2, int var3, ItemStack var4, List<Ingredient> var5);
        }
    }
}

