/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.evaporator.BlockEvaporator;
import sirttas.elementalcraft.block.instrument.crystallizer.TileCrystallizer;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ItemShard;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;
import sirttas.elementalcraft.rune.Rune;

public class CrystallizationRecipe
extends AbstractInstrumentRecipe<TileCrystallizer> {
    public static final String NAME = "crystallization";
    public static final IRecipeType<CrystallizationRecipe> TYPE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)ElementalCraft.createRL("crystallization"), (Object)new IRecipeType<CrystallizationRecipe>(){

        public String toString() {
            return CrystallizationRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:crystallization")
    public static IRecipeSerializer<CrystallizationRecipe> SERIALIZER;
    private NonNullList<Ingredient> ingredients;
    private final ImmutableMap<ItemStack, Integer> outputs;
    private final int totalWeight;
    private int elementAmount;

    public CrystallizationRecipe(ResourceLocation id, ElementType type, int elementAmount, Map<ItemStack, Integer> outputs, List<Ingredient> ingredients) {
        super(id, type);
        this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])((Ingredient[])ingredients.stream().toArray(Ingredient[]::new)));
        this.outputs = ImmutableMap.builder().putAll(outputs).orderEntriesByValue(Comparator.comparingInt(Integer::intValue).reversed()).build();
        this.totalWeight = outputs.values().stream().mapToInt(Integer::intValue).sum();
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public boolean matches(TileCrystallizer inv) {
        if (inv.getTankElementType() == this.getElementType() && inv.getItemCount() >= 2) {
            for (int i = 0; i < 2; ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(inv.getInventory().func_70301_a(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public Map<ItemStack, Integer> getOutputs() {
        return this.outputs;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    @Override
    public void process(TileCrystallizer instrument) {
        int luck = (int)Math.round((double)instrument.getRuneHandler().getBonus(Rune.BonusType.LUCK) * (Double)ECConfig.COMMON.crystallizerLuckRatio.get());
        IInventory inv = instrument.getInventory();
        for (int i = 2; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (BlockEvaporator.getShardElementType(stack) != this.elementType) continue;
            luck += ((ItemShard)stack.func_77973_b()).getElementAmount();
        }
        instrument.func_174888_l();
        instrument.getInventory().func_70299_a(0, this.getCraftingResult(instrument, luck));
    }

    @Override
    public ItemStack getCraftingResult(TileCrystallizer instrument) {
        return this.getCraftingResult(instrument, 0);
    }

    public ItemStack getCraftingResult(TileCrystallizer instrument, int luck) {
        int weight = this.totalWeight + luck * this.outputs.size();
        int roll = Math.min(instrument.func_145831_w().field_73012_v.nextInt(weight), weight - 1);
        for (Map.Entry entry : this.outputs.entrySet()) {
            if ((roll -= (Integer)entry.getValue() + luck) >= 0) continue;
            return ((ItemStack)entry.getKey()).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrystallizationRecipe> {
        final IRecipeFactory factory;

        public Serializer(IRecipeFactory factory) {
            this.factory = factory;
        }

        public CrystallizationRecipe read(ResourceLocation recipeId, JsonObject json) {
            ElementType type = ElementType.byName(JSONUtils.func_151200_h((JsonObject)json, (String)"element_type"));
            int elementAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(JSONUtils.func_152754_s((JsonObject)json, (String)"ingredients"));
            Map<ItemStack, Integer> outputs = StreamSupport.stream(JSONUtils.func_151214_t((JsonObject)json, (String)"outputs").spliterator(), false).filter(JsonObject.class::isInstance).map(JsonObject.class::cast).collect(Collectors.toMap(obj -> RecipeHelper.readRecipeOutput(JSONUtils.func_151200_h((JsonObject)obj, (String)"item")), obj -> JSONUtils.func_151203_m((JsonObject)obj, (String)"weight")));
            return this.factory.create(recipeId, type, elementAmount, outputs, (List<Ingredient>)ingredients);
        }

        public static NonNullList<Ingredient> readIngredients(JsonObject json) {
            NonNullList list = NonNullList.func_191196_a();
            list.add((Object)RecipeHelper.deserializeIngredient(json, "gem"));
            list.add((Object)RecipeHelper.deserializeIngredient(json, "crystal"));
            list.add((Object)RecipeHelper.deserializeIngredient(json, "shard"));
            return list;
        }

        public CrystallizationRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ElementType type = ElementType.byName(buffer.func_150789_c(Short.MAX_VALUE));
            int elementAmount = buffer.readInt();
            int i = buffer.readInt();
            HashMap outputs = Maps.newHashMap();
            for (int j = 0; j < i; ++j) {
                outputs.put(buffer.func_150791_c(), buffer.readInt());
            }
            i = buffer.readInt();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < i; ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return this.factory.create(recipeId, type, elementAmount, outputs, (List<Ingredient>)ingredients);
        }

        public void write(PacketBuffer buffer, CrystallizationRecipe recipe) {
            buffer.func_180714_a(recipe.getElementType().func_176610_l());
            buffer.writeInt(recipe.getElementAmount());
            buffer.writeInt(recipe.getOutputs().size());
            recipe.getOutputs().forEach((stack, weight) -> {
                buffer.func_150788_a(stack);
                buffer.writeInt(weight.intValue());
            });
            buffer.writeInt(recipe.func_192400_c().size());
            recipe.func_192400_c().forEach(ingredient -> ingredient.func_199564_a(buffer));
        }

        public static interface IRecipeFactory {
            public CrystallizationRecipe create(ResourceLocation var1, ElementType var2, int var3, Map<ItemStack, Integer> var4, List<Ingredient> var5);
        }
    }
}

