/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.inscriber.TileInscriber;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;
import sirttas.elementalcraft.rune.Rune;

public class InscriptionRecipe
extends AbstractInstrumentRecipe<TileInscriber> {
    public static final String NAME = "inscription";
    public static final IRecipeType<InscriptionRecipe> TYPE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)ElementalCraft.createRL("inscription"), (Object)new IRecipeType<InscriptionRecipe>(){

        public String toString() {
            return InscriptionRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:inscription")
    public static IRecipeSerializer<InscriptionRecipe> SERIALIZER;
    private final NonNullList<Ingredient> ingredients;
    private final ResourceLocation runeId;
    private final int elementAmount;
    private Rune output;

    public InscriptionRecipe(ResourceLocation id, ElementType type, int elementAmount, ResourceLocation runeId, List<Ingredient> ingredients) {
        super(id, type);
        this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])((Ingredient[])ingredients.stream().toArray(Ingredient[]::new)));
        this.runeId = runeId;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public boolean matches(TileInscriber inv) {
        if (inv.getTankElementType() == this.getElementType()) {
            return RecipeHelper.matchesUnordered(inv.getInventory(), this.ingredients);
        }
        return false;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack func_77571_b() {
        if (this.output == null) {
            this.output = (Rune)ElementalCraft.RUNE_MANAGER.get(this.runeId);
        }
        return this.output != null ? ECItems.rune.getRuneStack(this.output) : ItemStack.field_190927_a;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    @Override
    public void process(TileInscriber instrument) {
        instrument.func_174888_l();
        super.process(instrument);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InscriptionRecipe> {
        final IRecipeFactory factory;

        public Serializer(IRecipeFactory factory) {
            this.factory = factory;
        }

        public InscriptionRecipe read(ResourceLocation recipeId, JsonObject json) {
            ElementType type = ElementType.byName(JSONUtils.func_151200_h((JsonObject)json, (String)"element_type"));
            int elementAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = RecipeHelper.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            ingredients.add(0, (Object)RecipeHelper.deserializeIngredient(json, "slate"));
            ResourceLocation runeId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"output"));
            return this.factory.create(recipeId, type, elementAmount, runeId, (List<Ingredient>)ingredients);
        }

        public InscriptionRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ElementType type = ElementType.byName(buffer.func_150789_c(Short.MAX_VALUE));
            int elementAmount = buffer.readInt();
            ResourceLocation runeId = buffer.func_192575_l();
            int i = buffer.readInt();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < i; ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return this.factory.create(recipeId, type, elementAmount, runeId, (List<Ingredient>)ingredients);
        }

        public void write(PacketBuffer buffer, InscriptionRecipe recipe) {
            buffer.func_180714_a(recipe.getElementType().func_176610_l());
            buffer.writeInt(recipe.getElementAmount());
            buffer.func_192572_a(recipe.runeId);
            buffer.writeInt(recipe.func_192400_c().size());
            recipe.func_192400_c().forEach(ingredient -> ingredient.func_199564_a(buffer));
        }

        public static interface IRecipeFactory {
            public InscriptionRecipe create(ResourceLocation var1, ElementType var2, int var3, ResourceLocation var4, List<Ingredient> var5);
        }
    }
}

