/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.purifier.TilePurifier;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;
import sirttas.elementalcraft.rune.Rune;

public class PurifierRecipe
implements IInstrumentRecipe<TilePurifier> {
    private final ResourceLocation id;
    private final ItemStack result;
    protected Ingredient input;

    public PurifierRecipe(ItemStack ore) {
        ResourceLocation oreName = ore.func_77973_b().getRegistryName();
        this.input = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ore});
        this.id = ElementalCraft.createRL(oreName.func_110624_b() + '_' + oreName.func_110623_a() + "_to_pure_ore");
        this.result = ElementalCraft.PURE_ORE_MANAGER.createPureOre(ore.func_77973_b()).func_77946_l();
        this.result.func_190920_e(((Integer)ECConfig.COMMON.pureOreMultiplier.get()).intValue());
    }

    @Override
    public int getElementAmount() {
        return (Integer)ECConfig.COMMON.purifierBaseCost.get();
    }

    @Override
    public boolean matches(TilePurifier tile) {
        return tile.getItemHandler().map(inv -> {
            ItemStack stack = inv.getStackInSlot(0);
            ItemStack output = inv.getStackInSlot(1);
            return tile.getTankElementType() == ElementType.EARTH && ElementalCraft.PURE_ORE_MANAGER.isValidOre(stack) && this.input.test(stack) && (output.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)this.result) && output.func_190916_E() + this.result.func_190916_E() <= inv.getSlotLimit(1));
        }).orElse(false);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    public IRecipeType<?> func_222127_g() {
        return null;
    }

    @Override
    public ElementType getElementType() {
        return ElementType.EARTH;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public void process(TilePurifier instrument) {
        IInventory inv = instrument.getInventory();
        ItemStack in = inv.func_70301_a(0);
        ItemStack output = inv.func_70301_a(1);
        ItemStack craftingResult = this.getCraftingResult(instrument);
        int luck = (int)Math.round((double)instrument.getRuneHandler().getBonus(Rune.BonusType.LUCK) * (Double)ECConfig.COMMON.purifierLuckRatio.get());
        if (craftingResult.func_77969_a(output) && output.func_190916_E() + craftingResult.func_190916_E() <= output.func_77976_d()) {
            in.func_190918_g(1);
            output.func_190917_f(craftingResult.func_190916_E());
        } else if (output.func_190926_b()) {
            in.func_190918_g(1);
            inv.func_70299_a(1, craftingResult.func_77946_l());
        }
        if (luck > 0 && instrument.func_145831_w().field_73012_v.nextInt(100) < luck) {
            output.func_190917_f(1);
        }
        if (in.func_190926_b()) {
            inv.func_70304_b(0);
        }
    }

    public IRecipeSerializer<?> func_199559_b() {
        return null;
    }
}

