/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.rune;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicates;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.rune.handler.IRuneHandler;
import sirttas.elementalcraft.upgrade.AbstractUpgrade;

public class Rune
extends AbstractUpgrade<BonusType> {
    public static final Codec<Rune> CODEC = RecordCodecBuilder.create(builder -> AbstractUpgrade.codec(builder, BonusType.CODEC).and(builder.group((App)ResourceLocation.field_240908_a_.fieldOf("model").forGetter(Rune::getModelName), (App)ResourceLocation.field_240908_a_.fieldOf("effect_sprite").forGetter(Rune::getSpriteName))).apply((Applicative)builder, Rune::new));
    private ResourceLocation modelName;
    private ResourceLocation fxSpriteName;

    private Rune(IBlockPosPredicate predicate, Map<BonusType, Float> bonuses, int maxAmount, ResourceLocation modelName, ResourceLocation fxSpriteName) {
        super(predicate, new EnumMap<BonusType, Float>(bonuses), maxAmount);
        this.modelName = modelName;
        this.fxSpriteName = fxSpriteName;
    }

    public boolean canUpgrade(IWorldReader world, BlockPos pos, IRuneHandler handler) {
        return handler.getRuneCount() < handler.getMaxRunes() && this.canUpgrade(world, pos, handler.getRuneCount(this));
    }

    public void addInformation(List<ITextComponent> tooltip) {
        this.bonuses.forEach((type, multiplier) -> tooltip.add((ITextComponent)new TranslationTextComponent("rune_bonus.elementalcraft." + type.func_176610_l(), new Object[]{this.formatMultiplier((Float)multiplier)}).func_240699_a_(multiplier.floatValue() > 0.0f ? TextFormatting.BLUE : TextFormatting.RED)));
        if (this.maxAmount > 0) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.max_amount", new Object[]{this.maxAmount}).func_240699_a_(TextFormatting.YELLOW));
        }
    }

    private String formatMultiplier(Float multiplier) {
        return String.format("%+d%%", Math.round(multiplier.floatValue() * 100.0f));
    }

    public ResourceLocation getModelName() {
        return this.modelName;
    }

    public ResourceLocation getSpriteName() {
        return this.fxSpriteName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderMaterial getSprite() {
        return new RenderMaterial(AtlasTexture.field_110575_b, this.fxSpriteName);
    }

    public ITextComponent getDisplayName() {
        ResourceLocation id = this.getId();
        return new TranslationTextComponent("elementalcraft_rune." + id.func_110624_b() + '.' + id.func_110623_a());
    }

    public static class Builder {
        public static final Codec<Builder> CODEC = CODEC.xmap(rune -> {
            Builder builder = Builder.create().predicate(((Rune)rune).predicate).max(((Rune)rune).maxAmount).sprite(((Rune)rune).fxSpriteName);
            builder.model = ((Rune)rune).modelName;
            ((Rune)rune).bonuses.forEach(builder::addBonus);
            return builder;
        }, builder -> new Rune(builder.predicate, builder.bonuses, builder.maxAmount, builder.model, builder.sprite));
        private IBlockPosPredicate predicate = null;
        private final Map<BonusType, Float> bonuses = new EnumMap<BonusType, Float>(BonusType.class);
        private int maxAmount = 0;
        private ResourceLocation model = null;
        private ResourceLocation sprite = null;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder match(Block ... block) {
            return this.predicate(BlockPosPredicates.match((Block[])block));
        }

        public Builder match(ITag.INamedTag<Block> tag) {
            return this.predicate(BlockPosPredicates.match(tag));
        }

        public Builder predicate(IBlockPosPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder max(int max) {
            this.maxAmount = max;
            return this;
        }

        public Builder model(ItemModelBuilder model) {
            ResourceLocation modelLoc = model.getLocation();
            this.model = new ResourceLocation(modelLoc.func_110624_b(), modelLoc.func_110623_a().substring(5));
            return this;
        }

        public Builder sprite(ResourceLocation sprite) {
            this.sprite = sprite;
            return this;
        }

        public Builder addBonus(BonusType type, float value) {
            this.bonuses.put(type, Float.valueOf(value));
            return this;
        }

        public JsonElement toJson() {
            return CodecHelper.encode(CODEC, (Object)this);
        }
    }

    public static enum BonusType implements IStringSerializable
    {
        NONE("none"),
        SPEED("speed"),
        ELEMENT_PRESERVATION("element_preservation"),
        LUCK("luck");

        public static final Codec<BonusType> CODEC;
        private final String name;

        private BonusType(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static BonusType byName(String name) {
            for (BonusType bonusType : BonusType.values()) {
                if (!bonusType.name.equals(name)) continue;
                return bonusType;
            }
            return NONE;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(BonusType::values, BonusType::byName);
        }
    }
}

