/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeEffectInstance;
import sirttas.elementalcraft.item.ItemEC;
import sirttas.elementalcraft.spell.Spell;

public class EffectSpell
extends Spell {
    private final List<IForgeEffectInstance> effects;

    public EffectSpell(IForgeEffectInstance ... effects) {
        this.effects = ImmutableList.copyOf((Object[])effects);
    }

    private ActionResultType applyEffect(Entity target) {
        if (target instanceof LivingEntity) {
            this.effects.forEach(e -> ((LivingEntity)target).func_195064_c(new EffectInstance(e.getEffectInstance())));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType castOnEntity(Entity sender, Entity target) {
        return this.applyEffect(target);
    }

    @Override
    public ActionResultType castOnSelf(Entity sender) {
        return this.applyEffect(sender);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(List<ITextComponent> tooltip) {
        HashMultimap multimap = HashMultimap.create();
        if (!this.effects.isEmpty()) {
            for (IForgeEffectInstance forgeEffect : this.effects) {
                EffectInstance effectinstance = forgeEffect.getEffectInstance();
                TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(effectinstance.func_76453_d());
                Effect effect = effectinstance.func_188419_a();
                Map map = effect.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        multimap.put((Object)((Attribute)entry.getKey()), (Object)attributemodifier1);
                    }
                }
                if (effectinstance.func_76458_c() > 0) {
                    iformattabletextcomponent = new TranslationTextComponent("potion.withAmplifier", new Object[]{iformattabletextcomponent, new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c())});
                }
                if (effectinstance.func_76459_b() > 20) {
                    iformattabletextcomponent = new TranslationTextComponent("potion.withDuration", new Object[]{iformattabletextcomponent, EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)1.0f)});
                }
                tooltip.add((ITextComponent)iformattabletextcomponent.func_240699_a_(effect.func_220303_e().func_220306_a()));
            }
        }
        ItemEC.addAttributeMultimapToTooltip(tooltip, (Multimap<Attribute, AttributeModifier>)multimap, (ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.spell_effect_on_use").func_240699_a_(TextFormatting.DARK_PURPLE));
    }

    public final List<IForgeEffectInstance> getEffects() {
        return this.effects;
    }
}

