/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.inventory.ECInventoryHelper;
import sirttas.elementalcraft.item.holder.ItemElementHolder;
import sirttas.elementalcraft.spell.SpellInstance;
import sirttas.elementalcraft.spell.SpellTickManager;
import sirttas.elementalcraft.spell.properties.SpellProperties;

public class Spell
extends ForgeRegistryEntry<Spell>
implements IElementTypeProvider {
    protected static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("9da31711-7ea8-41d6-a4ef-3a6f7f679637");
    protected static final UUID REACH_DISTANCE_MODIFIER = UUID.fromString("1a6a2857-a598-40e4-9161-5b58bb14e9bc");
    public static final IForgeRegistry<Spell> REGISTRY = RegistryManager.ACTIVE.getRegistry(Spell.class);
    private String translationKey;
    protected SpellProperties properties = SpellProperties.NONE;

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"spell", (ResourceLocation)REGISTRY.getKey((IForgeRegistryEntry)this));
        }
        return this.translationKey;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot) {
        return HashMultimap.create();
    }

    public Multimap<Attribute, AttributeModifier> getOnUseAttributeModifiers() {
        return HashMultimap.create();
    }

    public ActionResultType castOnEntity(Entity sender, Entity target) {
        return ActionResultType.PASS;
    }

    public ActionResultType castOnBlock(Entity sender, BlockPos target) {
        return ActionResultType.PASS;
    }

    public ActionResultType castOnSelf(Entity sender) {
        return ActionResultType.PASS;
    }

    public void addSpellInstance(SpellInstance instance) {
        SpellTickManager.getInstance(instance.sender.field_70170_p).addSpellInstance(instance);
    }

    public boolean consume(Entity sender) {
        if (sender instanceof PlayerEntity && !((PlayerEntity)sender).func_184812_l_()) {
            ItemElementHolder holder;
            ItemStack stack = ItemElementHolder.find((PlayerEntity)sender, this.getElementType());
            int consumeAmount = this.getConsumeAmount();
            if (!stack.func_190926_b() && (holder = (ItemElementHolder)stack.func_77973_b()).getElementAmount(stack) >= consumeAmount) {
                holder.extractElement(stack, consumeAmount);
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean consume(Entity sender, IItemProvider item, int count) {
        if (sender instanceof PlayerEntity && !((PlayerEntity)sender).func_184812_l_()) {
            PlayerInventory inv = ((PlayerEntity)sender).field_71071_by;
            int slot = ECInventoryHelper.getSlotFor((IInventory)inv, new ItemStack(item));
            if (slot >= 0) {
                ItemStack ret = inv.func_70298_a(slot, count);
                if (!ret.func_190926_b()) {
                    return this.consume(sender, item, count - ret.func_190916_E());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void setProperties(SpellProperties properties) {
        this.properties = properties;
    }

    public int getCooldown() {
        return this.properties.getCooldown();
    }

    public int getConsumeAmount() {
        return this.properties.getConsumeAmount();
    }

    @Override
    public ElementType getElementType() {
        return this.properties.getElementType();
    }

    public Type getSpellType() {
        return this.properties.getSpellType();
    }

    public int getUseDuration() {
        return this.properties.getUseDuration();
    }

    public int getWeight() {
        return this.properties.getWeight();
    }

    public float getRange() {
        return this.properties.getRange();
    }

    public int getColor() {
        return this.properties.getColor();
    }

    public boolean isChannelable() {
        return this.getUseDuration() > 0;
    }

    public boolean isValid() {
        return this.getSpellType() != Type.NONE && this.getElementType() != ElementType.NONE;
    }

    public void addInformation(List<ITextComponent> tooltip) {
    }

    public String toString() {
        return this.getRegistryName().func_110623_a();
    }

    public static enum Type implements IStringSerializable
    {
        NONE("none"),
        COMBAT("combat"),
        UTILITY("utility"),
        MIXED("mixed");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return NONE;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(Type::values, Type::byName);
        }
    }
}

