/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.Spells;

public class SpellHelper {
    public static Spell getSpell(ItemStack stack) {
        return SpellHelper.getSpellFromTag((INBT)NBTHelper.getECTag(stack));
    }

    public static void setSpell(ItemStack stack, Spell spell) {
        CompoundNBT nbt = NBTHelper.getOrCreateECTag(stack);
        nbt.func_74778_a("spell", spell.getRegistryName().toString());
    }

    public static void removeSpell(ItemStack stack, Spell spell) {
        ListNBT list = SpellHelper.getSpellList(stack);
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = (CompoundNBT)list.get(i);
                if (!tag.func_74779_i("spell").equals(spell.getRegistryName().toString())) continue;
                int count = tag.func_74762_e("count");
                if (count > 1) {
                    tag.func_74768_a("count", count - 1);
                } else {
                    SpellHelper.moveSelected(stack, -1);
                    list.remove(i);
                    if (list.isEmpty()) {
                        SpellHelper.setSpell(stack, Spells.none);
                    }
                }
                return;
            }
        }
    }

    public static ListNBT getOrCreateSpellList(ItemStack stack) {
        CompoundNBT nbt = NBTHelper.getOrCreateECTag(stack);
        ListNBT list = nbt.func_150295_c("spell_list", 10);
        if (!nbt.func_74764_b("spell_list")) {
            nbt.func_218657_a("spell_list", (INBT)list);
        }
        return list;
    }

    public static void forEachSpell(ItemStack stack, ObjIntConsumer<Spell> consumer) {
        ListNBT list = SpellHelper.getSpellList(stack);
        if (list != null && !list.isEmpty()) {
            list.forEach(t -> {
                CompoundNBT tag = (CompoundNBT)t;
                consumer.accept(SpellHelper.getSpellFromTag((INBT)tag), tag.func_74762_e("count"));
            });
        }
    }

    public static List<Pair<Spell, Integer>> getSpellsAsMap(ItemStack stack) {
        ListNBT list = SpellHelper.getSpellList(stack);
        if (list != null && !list.isEmpty()) {
            ArrayList<Pair<Spell, Integer>> value = new ArrayList<Pair<Spell, Integer>>(list.size());
            list.forEach(t -> {
                CompoundNBT tag = (CompoundNBT)t;
                value.add(new Pair((Object)SpellHelper.getSpellFromTag((INBT)tag), (Object)tag.func_74762_e("count")));
            });
            return value;
        }
        return Collections.emptyList();
    }

    public static ListNBT getSpellList(ItemStack stack) {
        CompoundNBT nbt = NBTHelper.getECTag(stack);
        if (nbt != null && nbt.func_74764_b("spell_list")) {
            return nbt.func_150295_c("spell_list", 10);
        }
        return null;
    }

    public static int getSpellCount(ItemStack stack) {
        ListNBT list = SpellHelper.getSpellList(stack);
        if (list != null && !list.isEmpty()) {
            return list.stream().mapToInt(t -> ((CompoundNBT)t).func_74762_e("count")).sum();
        }
        return 0;
    }

    public static void addSpell(ItemStack stack, Spell spell) {
        ListNBT list = SpellHelper.getOrCreateSpellList(stack);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = (CompoundNBT)list.get(i);
            if (!SpellHelper.isSpellInTag((INBT)tag, spell)) continue;
            tag.func_74768_a("count", tag.func_74762_e("count") + 1);
            return;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("spell", spell.getRegistryName().toString());
        tag.func_74768_a("count", 1);
        list.add((Object)tag);
        if (list.size() == 1) {
            SpellHelper.setSpell(stack, spell);
        }
    }

    public static void moveSelected(ItemStack stack, int i) {
        ListNBT list = SpellHelper.getSpellList(stack);
        Spell spell = SpellHelper.getSpell(stack);
        if (list != null && !list.isEmpty()) {
            int selected = IntStream.range(0, list.size()).filter(j -> SpellHelper.isSpellInTag(list.get(j), spell)).findFirst().orElse(0) + i;
            if (selected < 0) {
                selected = list.size() - 1;
            } else if (selected >= list.size()) {
                selected = 0;
            }
            SpellHelper.setSpell(stack, SpellHelper.getSpellFromTag(list.get(selected)));
        }
    }

    private static Spell getSpellFromTag(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            return (Spell)Spell.REGISTRY.getValue(new ResourceLocation(((CompoundNBT)nbt).func_74779_i("spell")));
        }
        return Spells.none;
    }

    private static boolean isSpellInTag(INBT nbt, Spell spell) {
        if (nbt instanceof CompoundNBT && ((CompoundNBT)nbt).func_74764_b("spell")) {
            return ((CompoundNBT)nbt).func_74779_i("spell").equals(spell.getRegistryName().toString());
        }
        return false;
    }

    public static Spell randomSpell(Random rand) {
        return SpellHelper.randomSpell(Spell.REGISTRY.getValues(), rand);
    }

    public static Spell randomSpell(ElementType type, Random rand) {
        return SpellHelper.randomSpell(Spell.REGISTRY.getValues().stream().filter(spell -> spell.getElementType() == type && spell.isValid()).collect(Collectors.toList()), rand);
    }

    public static Spell randomSpell(Collection<Spell> spells, Random rand) {
        List list = spells.stream().filter(Spell::isValid).collect(Collectors.toList());
        int roll = rand.nextInt(list.stream().mapToInt(Spell::getWeight).sum());
        for (Spell spell : spells) {
            if ((roll -= spell.getWeight()) >= 0) continue;
            return spell;
        }
        return (Spell)list.get(list.size() - 1);
    }
}

