/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.upgrade;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;

public abstract class AbstractUpgrade<T extends IStringSerializable> {
    private ResourceLocation id;
    protected IBlockPosPredicate predicate;
    protected int maxAmount;
    protected final Map<T, Float> bonuses;

    protected static <T extends IStringSerializable, U extends AbstractUpgrade<T>> Products.P3<RecordCodecBuilder.Mu<U>, IBlockPosPredicate, Map<T, Float>, Integer> codec(RecordCodecBuilder.Instance<U> builder, Codec<T> bonusCodec) {
        return builder.group((App)Codecs.BLOCK_PREDICATE.fieldOf("predicate").forGetter(u -> u.predicate), (App)Codec.unboundedMap(bonusCodec, (Codec)Codec.FLOAT).optionalFieldOf("bonuses", (Object)ImmutableMap.of()).forGetter(AbstractUpgrade::getBonuses), (App)Codec.INT.optionalFieldOf("max_amount", (Object)0).forGetter(u -> u.maxAmount));
    }

    protected AbstractUpgrade(IBlockPosPredicate predicate, Map<T, Float> map, int maxAmount) {
        this.predicate = predicate;
        this.bonuses = map;
        this.maxAmount = maxAmount;
        this.id = null;
    }

    protected boolean canUpgrade(IWorldReader world, BlockPos pos, int amount) {
        return this.predicate.test(world, pos) && (this.maxAmount == 0 || amount < this.maxAmount);
    }

    public final Map<T, Float> getBonuses() {
        return this.bonuses;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public final void setId(ResourceLocation id) {
        this.id = id;
    }

    public String toString() {
        return this.id != null ? this.id.toString() : super.toString();
    }
}

