/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.registry.RegistryHelper;
import sirttas.elementalcraft.world.feature.SourceFeature;
import sirttas.elementalcraft.world.feature.structure.ECStructures;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECFeatures {
    @ObjectHolder(value="elementalcraft:source")
    public static Feature<NoFeatureConfig> source;
    private static ConfiguredFeature<?, ?> crystalOreConfig;
    private static ConfiguredFeature<?, ?> sourceConfig;
    private static StructureFeature<?, ?> sourceAltar;

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry r = event.getRegistry();
        SourceFeature source = new SourceFeature();
        RegistryHelper.register(r, source, "source");
        crystalOreConfig = ECFeatures.register("crystal_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ECBlocks.crystalOre.func_176223_P(), ((Integer)ECConfig.COMMON.inertCrystalSize.get()).intValue())).func_242733_d(((Integer)ECConfig.COMMON.inertCrystalYMax.get()).intValue())).func_242728_a()).func_242731_b(((Integer)ECConfig.COMMON.inertCrystalCount.get()).intValue()));
        sourceConfig = ECFeatures.register("source", (ConfiguredFeature)source.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l).func_242729_a(((Integer)ECConfig.COMMON.sourceSpawnChance.get()).intValue()));
        sourceAltar = ECFeatures.registerStructure("source_altar", ECStructures.SOURCE_ALTAR, NoFeatureConfig.field_236559_b_, ECStructures.SOURCE_ALTAR_PIECE_TYPE);
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        if (Boolean.FALSE.equals(ECConfig.COMMON.disableWorldGen.get()) && category != Biome.Category.THEEND && category != Biome.Category.NETHER) {
            if (Boolean.FALSE.equals(ECConfig.COMMON.disableInertCrystal.get())) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, crystalOreConfig);
            }
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, sourceConfig);
            if (category != Biome.Category.BEACH && category != Biome.Category.OCEAN && category != Biome.Category.RIVER && category != Biome.Category.SWAMP) {
                event.getGeneration().func_242516_a(sourceAltar);
            }
        }
    }

    private static <C extends IFeatureConfig> ConfiguredFeature<C, ?> register(String name, ConfiguredFeature<C, ?> feature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ElementalCraft.createRL(name), feature);
    }

    private static <C extends IFeatureConfig> StructureFeature<C, ?> registerStructure(String name, Structure<C> structure, C config, IStructurePieceType structurePieceType) {
        ResourceLocation location = ElementalCraft.createRL(name);
        StructureFeature structureFeature = (StructureFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)location, (Object)new StructureFeature(structure, config));
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)location, (Object)structurePieceType);
        Structure.field_236365_a_.put((Object)structure.func_143025_a(), structure);
        return structureFeature;
    }
}

