/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.codec;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CodecHelper {
    public static <T extends IForgeRegistryEntry<T>> Codec<T> getRegistryCodec(Supplier<IForgeRegistry<T>> suplier) {
        return ResourceLocation.field_240908_a_.comapFlatMap(id -> {
            IForgeRegistry registry = (IForgeRegistry)suplier.get();
            IForgeRegistryEntry value = registry.getValue(id);
            return value != null ? DataResult.success((Object)value) : DataResult.error((String)(id.toString() + " is not present in registry: " + registry.getRegistryName().toString()));
        }, IForgeRegistryEntry::getRegistryName);
    }

    public static <T> T decode(Decoder<T> decoder, JsonElement json) {
        return CodecHelper.decode(decoder, JsonOps.INSTANCE, json);
    }

    public static <T> T decode(Decoder<T> decoder, PacketBuffer buf) {
        return CodecHelper.decode(decoder, NBTDynamicOps.field_210820_a, buf.func_150793_b());
    }

    public static <T, U> T decode(Decoder<T> decoder, DynamicOps<U> ops, U input) {
        return (T)((Pair)CodecHelper.handleResult(decoder.decode(ops, input))).getFirst();
    }

    public static <T> void encode(Encoder<T> encoder, T data, PacketBuffer buf) {
        INBT nbt = (INBT)encoder.encode(data, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)NBTDynamicOps.field_210820_a.empty()).get().orThrow();
        if (nbt instanceof CompoundNBT) {
            buf.func_150786_a((CompoundNBT)nbt);
        }
    }

    public static <T> JsonElement encode(Encoder<T> encoder, T data) {
        return (JsonElement)CodecHelper.encode(encoder, JsonOps.INSTANCE, data);
    }

    public static <T, U> U encode(Encoder<T> encoder, DynamicOps<U> ops, T data) {
        return (U)CodecHelper.handleResult(encoder.encode(data, ops, ops.empty()));
    }

    public static <T> T handleResult(DataResult<T> result) {
        return (T)result.get().orThrow();
    }
}

