/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;

public class DataManagerFactory {
    private static final Constructor<?> SIMPLE_CONSTRUCTOR = DataManagerFactory.getConstructor("data.SimpleDataManager", Class.class, String.class);
    private static final Constructor<?> DEFAULTED_CONSTRUCTOR = DataManagerFactory.getConstructor("data.DefaultedDataManager", Class.class, String.class, Object.class);

    public static <T, M extends IDataManager<T>> M simple(Class<T> type, String folder) {
        return DataManagerFactory.construct(SIMPLE_CONSTRUCTOR, type, folder);
    }

    public static <T, M extends IDataManager<T>> M defaulted(Class<T> type, String folder, T defaultValue) {
        return DataManagerFactory.construct(DEFAULTED_CONSTRUCTOR, type, folder, defaultValue);
    }

    private static Constructor<?> getConstructor(String className, Class<?> ... classes) {
        try {
            return Class.forName("sirttas.dpanvil." + className, true, DataManagerFactory.class.getClassLoader()).getConstructor(classes);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            DataPackAnvilApi.LOGGER.error("Couldn't get constructor", (Throwable)e);
            return null;
        }
    }

    private static <T, M extends IDataManager<T>> M construct(Constructor<?> constructor, Object ... objects) {
        try {
            return (M)(constructor != null ? (IDataManager)constructor.newInstance(objects) : null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            DataPackAnvilApi.LOGGER.error("Couldn't construct new data manager", (Throwable)e);
            return null;
        }
    }
}

