/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.imc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import sirttas.dpanvil.api.data.IDataManager;

public class DataManagerIMC<T> {
    public static final String METHOD = "data_manager";
    private final ResourceLocation id;
    private final IDataManager<T> manager;
    private Codec<T> codec;
    private Function<JsonElement, T> readJson;
    private Function<PacketBuffer, T> readPacket;
    private BiConsumer<PacketBuffer, T> writePacket;

    public DataManagerIMC(ResourceLocation id, IDataManager<T> manager) {
        this.id = id;
        this.manager = manager;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IDataManager<T> getManager() {
        return this.manager;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    public Function<JsonElement, T> getReadJson() {
        return this.readJson;
    }

    public Function<PacketBuffer, T> getReadPacket() {
        return this.readPacket;
    }

    public BiConsumer<PacketBuffer, T> getWritePacket() {
        return this.writePacket;
    }

    public DataManagerIMC<T> withCodec(Codec<T> codec) {
        this.codec = codec;
        this.readJson = null;
        this.readPacket = null;
        this.writePacket = null;
        return this;
    }

    public DataManagerIMC<T> withSerializer(Function<JsonElement, T> readJson, Function<PacketBuffer, T> readPacket, BiConsumer<PacketBuffer, T> writePacket) {
        this.codec = null;
        this.readJson = readJson;
        this.readPacket = readPacket;
        this.writePacket = writePacket;
        return this;
    }

    public static <T> void enqueue(Supplier<DataManagerIMC<T>> supplier) {
        InterModComms.sendTo((String)"dpanvil", (String)METHOD, supplier);
    }
}

