/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.logical;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.logical.ListBlockPredicate;

public class OrBlockPredicate
extends ListBlockPredicate {
    public static final String NAME = "or";
    @ObjectHolder(value="dpanvil:or")
    public static BlockPosPredicateType<OrBlockPredicate> TYPE;
    public static final Codec<OrBlockPredicate> CODEC;

    public OrBlockPredicate(IBlockPosPredicate ... predicates) {
        this(Arrays.asList(predicates));
    }

    public OrBlockPredicate(Iterable<IBlockPosPredicate> predicates) {
        super(predicates);
    }

    @Override
    public boolean test(IWorldReader world, BlockPos pos) {
        return this.predicates.stream().anyMatch(predicate -> predicate.test(world, pos));
    }

    public BlockPosPredicateType<OrBlockPredicate> getType() {
        return TYPE;
    }

    @Override
    public IBlockPosPredicate or(IBlockPosPredicate ... predicates) {
        ArrayList list = Lists.newArrayList((Object[])predicates);
        list.addAll(this.predicates);
        return new OrBlockPredicate(list);
    }

    static {
        CODEC = OrBlockPredicate.codec(OrBlockPredicate::new);
    }
}

