/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoader;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.event.DataManagerReloadEvent;
import sirttas.dpanvil.api.imc.DataManagerIMC;
import sirttas.dpanvil.data.SimpleDataManager;
import sirttas.dpanvil.data.serializer.CodecJsonDataSerializer;
import sirttas.dpanvil.data.serializer.IJsonDataSerializer;

public class DataManagerWrapper
implements IFutureReloadListener {
    private final Map<ResourceLocation, IDataManager<?>> managers = Maps.newHashMap();
    private final Map<ResourceLocation, IJsonDataSerializer<?>> serializers = Maps.newHashMap();

    public <T, M extends IDataManager<T>> M getManager(ResourceLocation id) {
        return (M)this.managers.get(id);
    }

    public <T, M extends IDataManager<T>> M getManager(Class<T> clazz) {
        return (M)((IDataManager)this.managers.values().stream().filter(manager -> manager.getContentType().isAssignableFrom(clazz)).findAny().orElse(null));
    }

    public <T, S extends IJsonDataSerializer<T>> S getSerializer(ResourceLocation id) {
        return (S)this.serializers.get(id);
    }

    public <T> void putManagerFromIMC(Supplier<DataManagerIMC<T>> imc) {
        DataManagerIMC<T> message = imc.get();
        ResourceLocation id = message.getId();
        IDataManager<T> manager = message.getManager();
        this.serializers.put(id, this.buildSerializer(message));
        this.managers.put(id, manager);
        if (manager instanceof SimpleDataManager) {
            ((SimpleDataManager)manager).id = id;
        }
    }

    private <T> IJsonDataSerializer<T> buildSerializer(final DataManagerIMC<T> message) {
        Codec<T> codec = message.getCodec();
        return codec != null ? new CodecJsonDataSerializer<T>(codec) : new IJsonDataSerializer<T>(){

            @Override
            public T read(JsonElement json) {
                return message.getReadJson().apply(json);
            }

            @Override
            public T read(PacketBuffer buf) {
                return message.getReadPacket().apply(buf);
            }

            @Override
            public void write(T data, PacketBuffer buf) {
                message.getWritePacket().accept(buf, (PacketBuffer)data);
            }
        };
    }

    public Collection<ResourceLocation> ids() {
        return this.managers.keySet();
    }

    public Map<ResourceLocation, IDataManager<?>> getDataManagers() {
        return this.managers;
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        if (ModLoader.isLoadingStateValid()) {
            return CompletableFuture.allOf((CompletableFuture[])this.managers.values().stream().map(manager -> manager.func_215226_a(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor).thenRun(() -> MinecraftForge.EVENT_BUS.post(new DataManagerReloadEvent(manager)))).toArray(CompletableFuture[]::new)).thenRun(DataPackAnvil.ANNOTATION_PROCESSOR::applyDataHolder);
        }
        return CompletableFuture.completedFuture(null);
    }
}

