/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;

public class SimpleDataManager<T>
extends JsonReloadListener
implements IDataManager<T> {
    private static final Gson GSON = new GsonBuilder().create();
    private final Class<T> contentType;
    ResourceLocation id;
    private Map<ResourceLocation, T> data = ImmutableMap.of();

    public SimpleDataManager(Class<T> contentType, String folder) {
        super(GSON, folder);
        this.contentType = contentType;
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        Object serializer = DataPackAnvil.WRAPPER.getSerializer(this.id);
        objects.forEach((loc, jsonObject) -> map.put(loc, serializer.read((JsonElement)jsonObject)));
        this.setData(map);
    }

    @Override
    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    @Override
    public void setData(Map<ResourceLocation, T> map) {
        this.data = ImmutableMap.copyOf(map);
        DataPackAnvilApi.LOGGER.info("Loaded {} {}", (Object)this.data.size(), (Object)this.id);
    }

    @Override
    public Class<T> getContentType() {
        return this.contentType;
    }
}

