/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.network.message;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.data.DataHandler;
import sirttas.dpanvil.data.network.message.DataManagerMessage;

public class ReloadDataMessage {
    private final List<DataManagerMessage<?>> messages;

    public ReloadDataMessage() {
        this.messages = Lists.newArrayList();
    }

    public ReloadDataMessage(Collection<ResourceLocation> managers) {
        this.messages = managers.stream().map(DataManagerMessage::new).collect(Collectors.toList());
    }

    public static ReloadDataMessage decode(PacketBuffer buf) {
        ReloadDataMessage message = new ReloadDataMessage();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            DataManagerMessage managerMessage = new DataManagerMessage(buf.func_192575_l());
            managerMessage.decode(buf);
            message.messages.add(managerMessage);
        }
        return message;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.messages.size());
        for (DataManagerMessage<?> message : this.messages) {
            buf.func_192572_a(message.getId());
            message.encode(buf);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.messages.forEach(DataManagerMessage::process));
        DataPackAnvil.ANNOTATION_PROCESSOR.applyDataHolder();
        DataHandler.onDPAnvilUpdate();
        ctx.get().setPacketHandled(true);
    }
}

