/*
 * Decompiled with CFR 0.152.
 */
package com.crafting_mage.enchantingfever.enchantments.enchantmentclasses.armour;

import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class ColdThornsEnchantment
extends Enchantment {
    public double x;
    public double y;
    public double z;
    public World world;
    int maxLevel;

    public ColdThornsEnchantment(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType[] slots, int maxLevelIn) {
        super(rarityIn, typeIn, slots);
        this.maxLevel = maxLevelIn;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 10 + 20 * (enchantmentLevel - 1);
    }

    public int func_223551_b(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel) + 50;
    }

    public int func_77325_b() {
        return this.maxLevel;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ArmorItem ? true : super.func_92089_a(stack);
    }

    public void func_151367_b(LivingEntity user, Entity attacker, int level) {
        Random random = user.func_70681_au();
        Map.Entry entry = EnchantmentHelper.func_222189_b((Enchantment)Enchantments.field_92091_k, (LivingEntity)user);
        if (ColdThornsEnchantment.shouldHit(level, random)) {
            if (attacker != null) {
                attacker.func_70097_a(DamageSource.func_92087_a((Entity)user), (float)ColdThornsEnchantment.getDamage(level, random));
                int i = 20 + user.func_70681_au().nextInt(10 * level);
                ((LivingEntity)attacker).func_195064_c(new EffectInstance(Effects.field_76421_d, i, level));
            }
            if (entry != null) {
                ((ItemStack)entry.getValue()).func_222118_a(2, user, p_222183_1_ -> p_222183_1_.func_213361_c((EquipmentSlotType)entry.getKey()));
            }
        }
    }

    public static boolean shouldHit(int level, Random rnd) {
        if (level <= 0) {
            return false;
        }
        return rnd.nextFloat() < 0.15f * (float)level;
    }

    public static int getDamage(int level, Random rnd) {
        return level > 10 ? level - 10 : 1 + rnd.nextInt(4);
    }
}

