/*
 * Decompiled with CFR 0.152.
 */
package net.crafting_mage.enchantingmod.enchantment.enchantmentclasses.armourEnchants;

import java.util.Random;
import net.crafting_mage.enchantingmod.enchantment.ModEnchantments;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public class EnchantToxicThorns
extends Enchantment {
    public EnchantToxicThorns(String name, Enchantment.Rarity rarityIn, EnumEnchantmentType typeIn, EntityEquipmentSlot[] slots) {
        super(rarityIn, typeIn, slots);
        this.setRegistryName(name);
        this.func_77322_b(name);
    }

    public void func_151367_b(EntityLivingBase user, Entity attacker, int level) {
        Random random = user.func_70681_au();
        ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)ModEnchantments.toxicthorns, (EntityLivingBase)user);
        if (EnchantToxicThorns.shouldHit(level, random)) {
            if (attacker != null) {
                attacker.func_70097_a(DamageSource.func_92087_a((Entity)user), (float)EnchantToxicThorns.getDamage(level, random));
                ((EntityLivingBase)attacker).func_70690_d(new PotionEffect(MobEffects.field_76436_u, level, level + 2));
            }
            if (!itemstack.func_190926_b()) {
                this.damageArmor(itemstack, 3, user);
            }
        } else if (!itemstack.func_190926_b()) {
            this.damageArmor(itemstack, 1, user);
        }
    }

    public static boolean shouldHit(int level, Random rnd) {
        if (level <= 0) {
            return false;
        }
        return rnd.nextFloat() < 0.15f * (float)level;
    }

    public static int getDamage(int level, Random rnd) {
        return level > 10 ? level - 10 : 1 + rnd.nextInt(4);
    }

    private void damageArmor(ItemStack stack, int amount, EntityLivingBase entity) {
        int slot = -1;
        int x = 0;
        for (ItemStack i : entity.func_184193_aE()) {
            if (i == stack) {
                slot = x;
                break;
            }
            ++x;
        }
        if (slot == -1 || !(stack.func_77973_b() instanceof ISpecialArmor)) {
            stack.func_77972_a(1, entity);
            return;
        }
        ISpecialArmor armor = (ISpecialArmor)stack.func_77973_b();
        armor.damageArmor(entity, stack, DamageSource.func_92087_a((Entity)entity), amount, slot);
    }

    public boolean func_77326_a(Enchantment ench) {
        if (ench == Enchantments.field_92091_k) {
            return false;
        }
        return ench != ModEnchantments.coldthorns;
    }

    public boolean canApplyAtEnchantmentTable() {
        return true;
    }

    public boolean isAllowedOnBooks() {
        return true;
    }
}

