/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.ender_chest_horses;

import com.legacy.ender_chest_horses.EnderChestedMod;
import com.legacy.ender_chest_horses.capabillity.EnderHorseCapability;
import com.legacy.ender_chest_horses.capabillity.util.CapabilityProvider;
import com.legacy.ender_chest_horses.container.EnderHorseInventoryContainer;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class HorseEvents {
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof AbstractHorseEntity) {
            EnderHorseCapability.ifPresent((AbstractHorseEntity)event.getEntityLiving(), horse -> horse.tick());
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AbstractHorseEntity) {
            AbstractHorseEntity horse = (AbstractHorseEntity)event.getEntity();
            EnderHorseCapability.ifPresent(horse, enderHorse -> {});
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof AbstractHorseEntity) {
            EnderHorseCapability.ifPresent((AbstractHorseEntity)event.getEntityLiving(), horse -> {
                if (horse.isEnderChested()) {
                    if (!event.getEntityLiving().field_70170_p.field_72995_K) {
                        event.getEntityLiving().func_199703_a((IItemProvider)Blocks.field_150477_bB);
                    }
                    horse.setEnderChested(false);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof AbstractHorseEntity) {
            AbstractHorseEntity horse = (AbstractHorseEntity)event.getTarget();
            EnderHorseCapability.ifPresent(horse, enderHorse -> enderHorse.processInteract(event));
        }
    }

    @SubscribeEvent
    public void onCapabilityAttached(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof AbstractHorseEntity && !((Entity)event.getObject()).getCapability(EnderHorseCapability.INSTANCE).isPresent()) {
            event.addCapability(EnderChestedMod.locate("ender_horse_capability"), (ICapabilityProvider)new CapabilityProvider(new EnderHorseCapability((AbstractHorseEntity)event.getObject())));
        }
    }

    @SubscribeEvent
    public void onContainerOpened(PlayerContainerEvent.Open event) {
        if (event.getContainer() instanceof HorseInventoryContainer && event.getPlayer().func_184187_bx() != null && event.getPlayer().func_184187_bx() instanceof AbstractHorseEntity && event.getPlayer() instanceof ServerPlayerEntity) {
            EnderHorseCapability.ifPresent((AbstractHorseEntity)event.getPlayer().func_184187_bx(), enderHorse -> {
                if (enderHorse.isEnderChested()) {
                    HorseEvents.openEnderHorseContainer((ServerPlayerEntity)event.getPlayer(), (AbstractHorseEntity)event.getPlayer().func_184187_bx());
                }
            });
        }
    }

    public static void openEnderHorseContainer(ServerPlayerEntity player, AbstractHorseEntity enderHorse) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((id, inventory, playerIn) -> new EnderHorseInventoryContainer(id, inventory, enderHorse), enderHorse.func_200200_C_()), buffer -> buffer.writeInt(enderHorse.func_145782_y()));
        player.func_195066_a(Stats.field_188090_X);
    }
}

