/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.ender_chest_horses.capabillity;

import com.legacy.ender_chest_horses.HorseEvents;
import com.legacy.ender_chest_horses.capabillity.IEnderHorse;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EnderHorseCapability
implements IEnderHorse {
    @CapabilityInject(value=IEnderHorse.class)
    public static Capability<IEnderHorse> INSTANCE = null;
    private boolean enderChested;
    private AbstractHorseEntity enderHorse;
    protected Inventory horseChest;

    public EnderHorseCapability() {
    }

    public EnderHorseCapability(AbstractHorseEntity horseIn) {
        this.enderHorse = horseIn;
    }

    public static IEnderHorse get(AbstractHorseEntity player) {
        return EnderHorseCapability.getIfPresent(player, enderHorse -> enderHorse);
    }

    public static <E extends AbstractHorseEntity> void ifPresent(E enderHorseIn, Consumer<IEnderHorse> action) {
        if (enderHorseIn != null && enderHorseIn.getCapability(INSTANCE).isPresent()) {
            action.accept((IEnderHorse)enderHorseIn.getCapability(INSTANCE).resolve().get());
        }
    }

    public static <E extends AbstractHorseEntity> void ifPresent(E enderHorseIn, Consumer<IEnderHorse> action, Consumer<E> elseAction) {
        if (enderHorseIn != null) {
            if (enderHorseIn.getCapability(INSTANCE).isPresent()) {
                action.accept((IEnderHorse)enderHorseIn.getCapability(INSTANCE).resolve().get());
            } else {
                elseAction.accept(enderHorseIn);
            }
        }
    }

    @Nullable
    public static <E extends AbstractHorseEntity, R> R getIfPresent(E enderHorseIn, Function<IEnderHorse, R> action) {
        if (enderHorseIn != null && enderHorseIn.getCapability(INSTANCE).isPresent()) {
            return action.apply((IEnderHorse)enderHorseIn.getCapability(INSTANCE).resolve().get());
        }
        return null;
    }

    @Nullable
    public static <E extends AbstractHorseEntity, R> R getIfPresent(E enderHorseIn, Function<IEnderHorse, R> action, Function<E, R> elseAction) {
        if (enderHorseIn != null) {
            if (enderHorseIn.getCapability(INSTANCE).isPresent()) {
                return action.apply((IEnderHorse)enderHorseIn.getCapability(INSTANCE).resolve().get());
            }
            return elseAction.apply(enderHorseIn);
        }
        return null;
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        compound.func_74757_a("EnderChested", this.isEnderChested());
    }

    @Override
    public void read(CompoundNBT compound) {
        this.setEnderChested(compound.func_74767_n("EnderChested"));
    }

    @Override
    public void tick() {
        if (!this.enderHorse.field_70170_p.field_72995_K && this.isEnderChested()) {
            this.enderHorse.field_70170_p.func_72960_a((Entity)this.enderHorse, (byte)8);
        }
    }

    @Override
    public void processInteract(PlayerInteractEvent.EntityInteract event) {
        boolean canChest;
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = canChest = !(this.enderHorse instanceof LlamaEntity) && (this.enderHorse instanceof AbstractChestedHorseEntity && !((AbstractChestedHorseEntity)this.enderHorse).func_190695_dh() || !(this.enderHorse instanceof AbstractChestedHorseEntity));
        if (this.enderHorse instanceof AbstractChestedHorseEntity && this.isEnderChested() && stack.func_77973_b().getTags().contains(Tags.Blocks.CHESTS.func_230234_a_()) && !stack.func_77973_b().getTags().contains(Tags.Blocks.CHESTS_ENDER.func_230234_a_())) {
            if (!player.field_70170_p.field_72995_K) {
                event.setCanceled(true);
            }
        } else if (!this.isEnderChested() && canChest && stack.func_77973_b().getTags().contains(Tags.Blocks.CHESTS_ENDER.func_230234_a_()) && this.enderHorse.func_110248_bS()) {
            if (!player.field_70170_p.field_72995_K) {
                player.func_226292_a_(hand, true);
                this.enderHorse.func_184185_a(SoundEvents.field_187584_ax, 1.0f, 1.0f);
                event.setCanceled(true);
            }
            this.setEnderChested(true);
        } else if (!player.field_70170_p.field_72995_K && this.isEnderChested() && player instanceof ServerPlayerEntity && (player.func_225608_bj_() || stack.func_77973_b() == Items.field_151141_av || this.enderHorse instanceof HorseEntity && stack.func_77973_b() instanceof HorseArmorItem)) {
            HorseEvents.openEnderHorseContainer((ServerPlayerEntity)player, this.enderHorse);
            event.setCanceled(true);
        }
    }

    @Override
    public boolean isEnderChested() {
        return this.enderChested;
    }

    @Override
    public boolean setEnderChested(boolean chestedIn) {
        this.enderChested = chestedIn;
        return this.enderChested;
    }
}

