/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat;

import com.userofbricks.expandedcombat.client.renderer.entity.ECArrowEntityRenderer;
import com.userofbricks.expandedcombat.curios.ArrowCurio;
import com.userofbricks.expandedcombat.enchentments.ECEnchantments;
import com.userofbricks.expandedcombat.entity.ECEntities;
import com.userofbricks.expandedcombat.item.ECItemGroup;
import com.userofbricks.expandedcombat.item.ECItems;
import com.userofbricks.expandedcombat.item.GauntletItem;
import com.userofbricks.expandedcombat.item.recipes.RecipeSerializerInit;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.common.inventory.CuriosContainer;

@Mod(value="expanded_combat")
public class ExpandedCombat {
    public static final String MODID = "expanded_combat";
    public static final Tag<Item> arrow_curios = new ItemTags.Wrapper(new ResourceLocation("curios", "arrows"));
    public static final Predicate<ItemStack> arrow_predicate = stack -> stack.func_77973_b().func_206844_a(arrow_curios);
    public static final Tag<Item> hands_curios = new ItemTags.Wrapper(new ResourceLocation("curios", "hands"));
    public static final Predicate<ItemStack> hands_predicate = stack -> stack.func_77973_b().func_206844_a(hands_curios);
    public static final ItemGroup EC_GROUP = new ECItemGroup();

    public ExpandedCombat() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        ECEnchantments.ENCHANTMENTS.register(bus);
        ECItems.ITEMS.register(bus);
        RecipeSerializerInit.RECIPE_SERIALIZERS.register(bus);
        ECEntities.ENTITIES.register(bus);
        bus.addListener(this::comms);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCaps);
        MinecraftForge.EVENT_BUS.addListener(this::arrowPickup);
        MinecraftForge.EVENT_BUS.addListener(this::DamageGauntletEvent);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(this::drawSlotBack);
            bus.addListener(this::stitchTextures);
            bus.addListener(this::itemColors);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void arrowPickup(EntityItemPickupEvent e) {
        ItemStack toPickup = e.getItem().func_92059_d();
        PlayerEntity player = e.getPlayer();
        if (player.field_71070_bA instanceof CuriosContainer) {
            return;
        }
        if (!CuriosAPI.getCurioEquipped(arrow_predicate, (LivingEntity)player).map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.field_190927_a).func_190926_b()) {
            CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(iCurioItemHandler -> {
                ItemStack rem = toPickup.func_77946_l();
                CurioStackHandler curioStackHandler = iCurioItemHandler.getStackHandler("arrows");
                rem = curioStackHandler.insertItem(0, rem, true);
                if (toPickup.func_190916_E() > rem.func_190916_E()) {
                    if (rem.func_190926_b()) {
                        curioStackHandler.insertItem(0, toPickup, false);
                        toPickup.func_190920_e(0);
                        e.setCanceled(true);
                    } else {
                        toPickup.func_190920_e(rem.func_190916_E());
                    }
                }
            });
        }
    }

    private void DamageGauntletEvent(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        Optional optionalImmutableTriple = CuriosAPI.getCurioEquipped(hands_predicate, (LivingEntity)player);
        ItemStack stack = optionalImmutableTriple.map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.field_190927_a);
        CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(iCurioItemHandler -> {
            if (!player.func_184812_l_() && stack.func_77973_b() instanceof GauntletItem && optionalImmutableTriple.isPresent()) {
                stack.func_222118_a(1, (LivingEntity)player, damager -> CuriosAPI.onBrokenCurio((String)((String)((ImmutableTriple)optionalImmutableTriple.get()).getLeft()), (int)((Integer)((ImmutableTriple)optionalImmutableTriple.get()).getMiddle()), (LivingEntity)damager));
            }
        });
    }

    private void comms(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("quiver").setHidden(true));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("arrows").setHidden(true));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("hands"));
        InterModComms.sendTo((String)"curios", (String)"register_icon", () -> new Tuple((Object)"quiver", (Object)new ResourceLocation(MODID, "item/empty_quiver_slot")));
        InterModComms.sendTo((String)"curios", (String)"register_icon", () -> new Tuple((Object)"arrows", (Object)new ResourceLocation(MODID, "item/empty_arrows_slot")));
    }

    private void drawSlotBack(GuiContainerEvent.DrawBackground e) {
        if (e.getGuiContainer() instanceof CuriosScreen) {
            CuriosScreen curiosScreen = (CuriosScreen)e.getGuiContainer();
            int i = curiosScreen.getGuiLeft();
            int j = curiosScreen.getGuiTop();
            curiosScreen.blit(i + 77, j + 17, 7, 7, 18, 36);
        }
    }

    public void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            String[] icons;
            for (String icon : icons = new String[]{"arrows", "quiver"}) {
                evt.addSprite(new ResourceLocation(MODID, "item/empty_" + icon + "_slot"));
            }
        }
    }

    public void itemColors(ColorHandlerEvent.Item event) {
        ItemColors itemcolors = event.getItemColors();
        itemcolors.func_199877_a((itemStack, itemLayer) -> itemLayer == 1 ? PotionUtils.func_190932_c((ItemStack)itemStack) : -1, new IItemProvider[]{(IItemProvider)ECItems.IRON_TIPPED_ARROW.get(), (IItemProvider)ECItems.DIAMOND_TIPPED_ARROW.get(), (IItemProvider)ECItems.NETHERITE_TIPPED_ARROW.get()});
    }

    private void attachCaps(AttachCapabilitiesEvent<ItemStack> e) {
        ItemStack stack = (ItemStack)e.getObject();
        if (stack.func_77973_b().func_206844_a(arrow_curios)) {
            final ArrowCurio arrowCurio = new ArrowCurio();
            e.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(() -> arrowCurio);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        this.registerEtityModels(event.getMinecraftSupplier());
    }

    private void registerEtityModels(Supplier<Minecraft> minecraft) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ECEntities.EC_ARROW_ENTITY.get()), renderManager -> new ECArrowEntityRenderer(renderManager));
    }

    public static ICapabilityProvider createProvider(ICurio curio) {
        return new Provider(curio);
    }

    public static class Provider
    implements ICapabilityProvider {
        final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

        Provider(ICurio curio) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.capability);
        }
    }
}

