/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.entity.projectile;

import com.google.common.collect.Sets;
import com.userofbricks.expandedcombat.entity.ECEntities;
import com.userofbricks.expandedcombat.item.ArrowType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ECArrowEntity
extends AbstractArrowEntity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(ECArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Potion potion = Potions.field_185229_a;
    private final Set<EffectInstance> customPotionEffects = Sets.newHashSet();
    private boolean fixedColor;
    private ArrowType arrowType = ArrowType.IRON;

    public ECArrowEntity(EntityType<? extends ECArrowEntity> p_i50172_1_, World p_i50172_2_) {
        super(p_i50172_1_, p_i50172_2_);
    }

    public ECArrowEntity(World worldIn, double x, double y, double z) {
        super((EntityType)ECEntities.EC_ARROW_ENTITY.get(), x, y, z, worldIn);
    }

    public ECArrowEntity(World worldIn, LivingEntity shooter) {
        super((EntityType)ECEntities.EC_ARROW_ENTITY.get(), shooter, worldIn);
    }

    public void setPotionEffect(ItemStack stack) {
        if (stack.func_77973_b() == this.arrowType.getTippedArrow()) {
            int i;
            this.potion = PotionUtils.func_185191_c((ItemStack)stack);
            List collection = PotionUtils.func_185190_b((ItemStack)stack);
            if (!collection.isEmpty()) {
                for (EffectInstance effectinstance : collection) {
                    this.customPotionEffects.add(new EffectInstance(effectinstance));
                }
            }
            if ((i = ECArrowEntity.getCustomColor(stack)) == -1) {
                this.refreshColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (stack.func_77973_b() == this.arrowType.getArrow()) {
            this.potion = Potions.field_185229_a;
            this.customPotionEffects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack itemStack) {
        CompoundNBT compoundnbt = itemStack.func_77978_p();
        return compoundnbt != null && compoundnbt.func_150297_b("CustomPotionColor", 99) ? compoundnbt.func_74762_e("CustomPotionColor") : -1;
    }

    private void refreshColor() {
        this.fixedColor = false;
        if (this.potion == Potions.field_185229_a && this.customPotionEffects.isEmpty()) {
            this.field_70180_af.func_187227_b(COLOR, (Object)-1);
        } else {
            this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.potion, this.customPotionEffects)));
        }
    }

    public void addEffect(EffectInstance effect) {
        this.customPotionEffects.add(effect);
        this.func_184212_Q().func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.potion, this.customPotionEffects)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)-1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.customPotionEffects.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.potion = Potions.field_185229_a;
            this.customPotionEffects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)-1);
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.getColor();
        if (i != -1 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    private void setFixedColor(int p_191507_1_) {
        this.fixedColor = true;
        this.field_70180_af.func_187227_b(COLOR, (Object)p_191507_1_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.potion != Potions.field_185229_a && this.potion != null) {
            compound.func_74778_a("Potion", Registry.field_212621_j.func_177774_c((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.func_74768_a("Color", this.getColor());
        }
        if (!this.customPotionEffects.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.customPotionEffects) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            compound.func_218657_a("CustomPotionEffects", (INBT)listnbt);
        }
        CompoundNBT arrowTypenbt = new CompoundNBT();
        compound.func_74778_a("ArrowType", this.arrowType.name());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Potion", 8)) {
            this.potion = PotionUtils.func_185187_c((CompoundNBT)compound);
        }
        for (EffectInstance effectinstance : PotionUtils.func_185192_b((CompoundNBT)compound)) {
            this.addEffect(effectinstance);
        }
        if (compound.func_150297_b("Color", 99)) {
            this.setFixedColor(compound.func_74762_e("Color"));
        } else {
            this.refreshColor();
        }
        if (compound.func_74764_b("ArrowType")) {
            String type = compound.func_74779_i("ArrowType");
            this.arrowType = ArrowType.valueOf(type);
        }
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        for (EffectInstance effectinstance : this.potion.func_185170_a()) {
            living.func_195064_c(new EffectInstance(effectinstance.func_188419_a(), Math.max(effectinstance.func_76459_b() / 8, 1), effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
        }
        if (!this.customPotionEffects.isEmpty()) {
            for (EffectInstance effectinstance1 : this.customPotionEffects) {
                living.func_195064_c(effectinstance1);
            }
        }
    }

    protected ItemStack func_184550_j() {
        if (this.customPotionEffects.isEmpty() && this.potion == Potions.field_185229_a) {
            return new ItemStack((IItemProvider)this.arrowType.getArrow());
        }
        ItemStack itemstack = new ItemStack((IItemProvider)this.arrowType.getTippedArrow());
        PotionUtils.func_185188_a((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.func_185184_a((ItemStack)itemstack, this.customPotionEffects);
        if (this.fixedColor) {
            itemstack.func_196082_o().func_74768_a("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    public void setArrowType(ArrowType arrowType) {
        this.arrowType = arrowType;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

