/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import com.userofbricks.expandedcombat.ExpandedCombat;
import com.userofbricks.expandedcombat.curios.GauntletCurio;
import com.userofbricks.expandedcombat.item.IGauntletMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class GauntletItem
extends Item {
    private final ResourceLocation GAUNTLET_TEXTURE;
    private final IGauntletMaterial material;
    private final float attackDamage;
    protected final int armorAmount;

    public GauntletItem(IGauntletMaterial materialIn, Item.Properties properties) {
        super(properties.func_200915_b(materialIn.getDurability()));
        this.material = materialIn;
        this.GAUNTLET_TEXTURE = new ResourceLocation("expanded_combat", "textures/entity/gauntlet/" + materialIn.getTextureName() + ".png");
        this.attackDamage = materialIn.getAttackDamage();
        this.armorAmount = materialIn.getArmorAmount();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT unused) {
        return ExpandedCombat.createProvider(new GauntletCurio(stack, ((GauntletItem)stack.func_77973_b()).getGAUNTLET_TEXTURE()));
    }

    public IGauntletMaterial getMaterial() {
        return this.material;
    }

    public int func_77619_b() {
        return this.material.getEnchantability();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.material.getRepairMaterial().test(repair) || super.func_82789_a(toRepair, repair);
    }

    public int getArmorAmount() {
        return this.armorAmount;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public ResourceLocation getGAUNTLET_TEXTURE() {
        return this.GAUNTLET_TEXTURE;
    }
}

