/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.curios;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.userofbricks.expandedcombat.client.renderer.model.GauntletModel;
import com.userofbricks.expandedcombat.enchentments.ECEnchantments;
import com.userofbricks.expandedcombat.item.GauntletItem;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class GauntletCurio
implements ICurio {
    private Object model;
    private final ItemStack stack;
    private final ResourceLocation GAUNTLET_TEXTURE;
    protected static final ResourceLocation ENCHANTED_ITEM_GLINT_RES = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final UUID ATTACK_UUID = UUID.fromString("7ce10414-adcc-4bf2-8804-f5dbd39fadaf");
    private static final UUID ARMOR_UUID = UUID.fromString("38faf191-bf78-4654-b349-cc1f4f1143bf");
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("b64fd3d6-a9fe-46a1-a972-90e4b0849678");
    private static final UUID KNOCKBACK_UUID = UUID.fromString("a3617883-03fa-4538-a821-7c0a506e8c56");

    public GauntletCurio(ItemStack stack, ResourceLocation gauntlet_texture) {
        this.stack = stack;
        this.GAUNTLET_TEXTURE = gauntlet_texture;
    }

    public void playRightClickEquipSound(LivingEntity livingEntity) {
        livingEntity.field_70170_p.func_184133_a(null, new BlockPos(livingEntity.func_213303_ch()), ((GauntletItem)this.stack.func_77973_b()).getMaterial().getSoundEvent(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier) {
        HashMultimap atts = HashMultimap.create();
        if (CuriosApi.getCuriosHelper().getCurioTags(this.stack.func_77973_b()).contains(identifier) && this.stack.func_77973_b() instanceof GauntletItem) {
            float attackDamage = ((GauntletItem)this.stack.func_77973_b()).getAttackDamage();
            int armorAmount = ((GauntletItem)this.stack.func_77973_b()).getArmorAmount();
            float knockbackResistance = ((GauntletItem)this.stack.func_77973_b()).getMaterial().getKnockback_resistance();
            float toughness = ((GauntletItem)this.stack.func_77973_b()).getMaterial().getToughness();
            atts.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(ATTACK_UUID, "Attack damage bonus", (double)(attackDamage + (float)Math.round(attackDamage / 2.0f * (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)this.stack))), AttributeModifier.Operation.ADDITION));
            atts.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(ARMOR_UUID, "Armor bonus", (double)armorAmount, AttributeModifier.Operation.ADDITION));
            atts.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(ARMOR_UUID, "Armor Toughness bonus", (double)toughness, AttributeModifier.Operation.ADDITION));
            atts.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback resistance bonus", (double)(knockbackResistance + (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ECEnchantments.KNOCKBACK_RESISTANCE.get()), (ItemStack)this.stack) / 5.0f), AttributeModifier.Operation.ADDITION));
            atts.put((Object)Attributes.field_233824_g_, (Object)new AttributeModifier(KNOCKBACK_UUID, "Knockback bonus", (double)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)this.stack), AttributeModifier.Operation.ADDITION));
        }
        return atts;
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
        return true;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(this.model instanceof GauntletModel)) {
            this.model = new GauntletModel();
        }
        GauntletModel gauntlet = (GauntletModel)((Object)this.model);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{gauntlet});
        gauntlet.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        gauntlet.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)gauntlet.func_228282_a_(this.GAUNTLET_TEXTURE), (boolean)false, (boolean)this.stack.func_77962_s());
        gauntlet.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean canRightClickEquip() {
        return true;
    }
}

