/*
 * Decompiled with CFR 0.152.
 */
package harmonised.explosiont.events;

import harmonised.explosiont.util.BlockInfo;
import harmonised.explosiont.util.RegistryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;

public class ChunkDataHandler {
    public static Map<ResourceLocation, Map<Integer, List<BlockInfo>>> toHealDimMap = new HashMap<ResourceLocation, Map<Integer, List<BlockInfo>>>();

    public static void init() {
        toHealDimMap = new HashMap<ResourceLocation, Map<Integer, List<BlockInfo>>>();
    }

    public static void handleChunkDataLoad(ChunkDataEvent.Load event) {
        CompoundNBT levelNBT;
        CompoundNBT chunkNBT = event.getData();
        if (chunkNBT != null && (levelNBT = chunkNBT.func_74775_l("Level")).func_74764_b("blocksToHeal")) {
            CompoundNBT blocksToHealNBT;
            World world = (World)event.getWorld();
            ResourceLocation dimResLoc = RegistryHelper.getDimensionResLoc(world);
            if (!toHealDimMap.containsKey(dimResLoc)) {
                toHealDimMap.put(dimResLoc, new HashMap());
            }
            if ((blocksToHealNBT = (CompoundNBT)levelNBT.func_74781_a("blocksToHeal")) == null) {
                return;
            }
            HashMap blocksToAddTypes = new HashMap();
            Set keySet = blocksToHealNBT.func_150296_c();
            keySet.forEach(key -> {
                CompoundNBT entry = blocksToHealNBT.func_74775_l(key);
                if (!blocksToAddTypes.containsKey(entry.func_74762_e("type"))) {
                    blocksToAddTypes.put(entry.func_74762_e("type"), new ArrayList());
                }
                ((List)blocksToAddTypes.get(entry.func_74762_e("type"))).add(new BlockInfo(dimResLoc, NBTUtil.func_190008_d((CompoundNBT)entry.func_74775_l("state")), NBTUtil.func_186861_c((CompoundNBT)entry.func_74775_l("pos")), entry.func_74762_e("ticksLeft"), entry.func_74762_e("type"), entry.func_74775_l("tileEntity")));
            });
            for (Map.Entry entry : blocksToAddTypes.entrySet()) {
                if (!toHealDimMap.get(dimResLoc).containsKey(entry.getKey())) {
                    toHealDimMap.get(dimResLoc).put((Integer)entry.getKey(), new ArrayList());
                }
                List<BlockInfo> blocksToHeal = toHealDimMap.get(dimResLoc).get(entry.getKey());
                blocksToHeal.removeAll((Collection)entry.getValue());
                blocksToHeal.addAll((Collection)entry.getValue());
                blocksToHeal.sort(Comparator.comparingInt(blockInfo -> blockInfo.pos.func_177956_o()));
            }
        }
    }

    public static void handleChunkDataSave(ChunkDataEvent.Save event) {
        World world = (World)event.getWorld();
        ResourceLocation dimResLoc = RegistryHelper.getDimensionResLoc(world);
        if (toHealDimMap.containsKey(dimResLoc)) {
            Map<Integer, List<BlockInfo>> toHealTypeMap = toHealDimMap.get(dimResLoc);
            CompoundNBT levelNBT = (CompoundNBT)event.getData().func_74781_a("Level");
            if (levelNBT == null) {
                return;
            }
            ArrayList<BlockInfo> chunkBlocksToHeal = new ArrayList<BlockInfo>();
            ChunkPos chunkPos = event.getChunk().func_76632_l();
            for (Map.Entry<Integer, List<BlockInfo>> entry : toHealTypeMap.entrySet()) {
                List<BlockInfo> blocksToHeal = entry.getValue();
                for (BlockInfo blockInfo : blocksToHeal) {
                    if (!new ChunkPos(blockInfo.pos).equals((Object)chunkPos)) continue;
                    chunkBlocksToHeal.add(blockInfo);
                }
            }
            if (chunkBlocksToHeal.size() <= 0) {
                return;
            }
            CompoundNBT newBlocksToHealNBT = new CompoundNBT();
            int i = 0;
            for (BlockInfo blockInfo : chunkBlocksToHeal) {
                CompoundNBT insidesNBT = new CompoundNBT();
                insidesNBT.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)blockInfo.pos));
                insidesNBT.func_218657_a("state", (INBT)NBTUtil.func_190009_a((BlockState)blockInfo.state));
                insidesNBT.func_74768_a("ticksLeft", blockInfo.ticksLeft);
                insidesNBT.func_74768_a("type", blockInfo.type);
                if (blockInfo.tileEntityNBT != null) {
                    insidesNBT.func_218657_a("tileEntity", (INBT)blockInfo.tileEntityNBT);
                }
                newBlocksToHealNBT.func_218657_a(i++ + "", (INBT)insidesNBT);
                if (event.getWorld().func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) continue;
                toHealTypeMap.get(blockInfo.type).remove(blockInfo);
            }
            levelNBT.func_218657_a("blocksToHeal", (INBT)newBlocksToHealNBT);
        }
    }
}

