/*
 * Decompiled with CFR 0.152.
 */
package harmonised.explosiont.events;

import harmonised.explosiont.config.Config;
import harmonised.explosiont.events.ChunkDataHandler;
import harmonised.explosiont.util.BlockInfo;
import harmonised.explosiont.util.RegistryHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;

public class WorldTickHandler {
    private static final Random rand = new Random();
    private static final Map<ResourceLocation, Map<Integer, Double>> dimLastHeal = new HashMap<ResourceLocation, Map<Integer, Double>>();
    private static final Map<ResourceLocation, Set<Integer>> dimForceHeal = new HashMap<ResourceLocation, Set<Integer>>();
    private static final Map<ResourceLocation, Boolean> dimWasDay = new HashMap<ResourceLocation, Boolean>();
    private static final Double ticksPerHealExplosion = Config.config.ticksPerHealExplosion.get();
    private static final Double ticksPerHealFire = Config.config.ticksPerHealFire.get();
    private static final Integer speedUpTresholdExplosion = Config.config.speedUpTresholdExplosion.get();
    private static final Integer speedUpTresholdFire = Config.config.speedUpTresholdFire.get();
    private static final boolean onlyHealPastMorning = Config.config.onlyHealPastMorning.get();

    public static void handleWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        ResourceLocation dimResLoc = RegistryHelper.getDimensionResLoc(world);
        if (!dimForceHeal.containsKey(dimResLoc)) {
            dimForceHeal.put(dimResLoc, new HashSet());
        }
        if (!dimWasDay.containsKey(dimResLoc)) {
            dimWasDay.put(dimResLoc, WorldTickHandler.isDayTime(world));
        }
        if (!ChunkDataHandler.toHealDimMap.containsKey(dimResLoc)) {
            ChunkDataHandler.toHealDimMap.put(dimResLoc, new HashMap());
        }
        for (Map.Entry<Integer, List<BlockInfo>> entry : ChunkDataHandler.toHealDimMap.get(dimResLoc).entrySet()) {
            boolean forceHeal = dimForceHeal.get(dimResLoc).contains(entry.getKey());
            List<BlockInfo> blocksToHeal = entry.getValue();
            if (onlyHealPastMorning || forceHeal) {
                if (!dimWasDay.get(dimResLoc).booleanValue() && WorldTickHandler.isDayTime(world) || forceHeal) {
                    blocksToHeal.forEach(blockToHeal -> {
                        blockToHeal.ticksLeft = -1;
                    });
                }
            } else {
                blocksToHeal.forEach(blockToHeal -> --blockToHeal.ticksLeft);
            }
            if (!dimLastHeal.containsKey(dimResLoc)) {
                dimLastHeal.put(dimResLoc, new HashMap());
            }
            WorldTickHandler.healBlocks(world, blocksToHeal, entry.getKey(), forceHeal);
            if (blocksToHeal.size() != 0) continue;
            dimForceHeal.get(dimResLoc).remove(entry.getKey());
        }
        dimWasDay.replace(dimResLoc, WorldTickHandler.isDayTime(world));
    }

    private static boolean isDayTime(World world) {
        return world.func_73046_m().func_71218_a(World.field_234918_g_).func_72935_r();
    }

    private static void healBlocks(World world, List<BlockInfo> blocksToHeal, int type, boolean forceHeal) {
        ResourceLocation dimResLoc = RegistryHelper.getDimensionResLoc(world);
        if (blocksToHeal.size() > 0) {
            int speedUpTreshold;
            double ticksPerHeal;
            if (type == 0) {
                ticksPerHeal = ticksPerHealExplosion;
                speedUpTreshold = speedUpTresholdExplosion;
            } else {
                ticksPerHeal = ticksPerHealFire;
                speedUpTreshold = speedUpTresholdFire;
            }
            if (!dimLastHeal.get(dimResLoc).containsKey(type)) {
                dimLastHeal.get(dimResLoc).put(type, 0.0);
            }
            dimLastHeal.get(dimResLoc).replace(type, dimLastHeal.get(dimResLoc).get(type) + 1.0);
            double cost = blocksToHeal.size() > speedUpTreshold && speedUpTreshold > 0 ? ticksPerHeal * ((double)speedUpTreshold / (double)blocksToHeal.size()) : ticksPerHeal;
            int toHeal = (int)(dimLastHeal.get(dimResLoc).get(type) / cost);
            dimLastHeal.get(dimResLoc).replace(type, dimLastHeal.get(dimResLoc).get(type) % cost);
            int index = -1;
            int healed = 0;
            while ((healed < toHeal || forceHeal) && blocksToHeal.size() > ++index) {
                BlockInfo blockInfo = blocksToHeal.get(index);
                ChunkPos chunkPos = new ChunkPos(blockInfo.pos);
                boolean chunkExists = WorldTickHandler.checkChunkExists(world, chunkPos);
                if (!chunkExists && !forceHeal || blockInfo.ticksLeft >= 0 && !forceHeal) continue;
                WorldTickHandler.healBlock(world, blockInfo);
                blocksToHeal.remove(blockInfo);
                ++healed;
            }
        } else {
            dimForceHeal.get(dimResLoc).remove(type);
            dimLastHeal.get(dimResLoc).replace(type, 0.0);
        }
    }

    private static void healBlock(World world, BlockInfo blockInfo) {
        BlockPos pos = blockInfo.pos;
        Block block = world.func_180495_p(pos).func_177230_c();
        FluidState fluidInfo = world.func_204610_c(pos);
        if (block.equals(Blocks.field_150350_a) || block.equals(Blocks.field_201941_jj) || block.equals(Blocks.field_150480_ab) || !fluidInfo.func_206888_e() && !fluidInfo.func_206889_d()) {
            if (blockInfo.state.func_235901_b_((Property)GrassBlock.field_196382_a)) {
                blockInfo.state = (BlockState)blockInfo.state.func_206870_a((Property)GrassBlock.field_196382_a, (Comparable)Boolean.valueOf(false));
            }
            if (blockInfo.state.func_235901_b_((Property)LeavesBlock.field_208494_a)) {
                blockInfo.state = (BlockState)blockInfo.state.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
            }
            world.func_180501_a(pos, blockInfo.state, blockInfo.type == 0 ? 3 : 18);
            if (blockInfo.tileEntityNBT != null && blockInfo.tileEntityNBT.func_186856_d() > 0) {
                world.func_175690_a(pos, TileEntity.func_235657_b_((BlockState)blockInfo.state, (CompoundNBT)blockInfo.tileEntityNBT));
            }
            world.func_217357_a(Entity.class, new AxisAlignedBB(pos, pos.func_177984_a().func_177968_d().func_177974_f())).forEach(a -> {
                BlockPos entityPos = new BlockPos(a.func_213303_ch());
                int i = 1;
                while (world.func_180495_p(entityPos.func_177981_b(i)).func_200132_m() || world.func_180495_p(entityPos.func_177981_b(i + 1)).func_200132_m()) {
                    ++i;
                }
                a.func_70107_b(a.func_213303_ch().func_82615_a(), a.func_213303_ch().field_72448_b + (double)i, a.func_213303_ch().field_72449_c);
                world.func_184148_a(null, a.func_213303_ch().func_82615_a(), a.func_213303_ch().func_82617_b(), a.func_213303_ch().func_82616_c(), SoundEvents.field_187544_ad, SoundCategory.BLOCKS, 0.8f + rand.nextFloat() * 0.4f, 0.9f + rand.nextFloat() * 0.15f);
            });
        } else {
            ListNBT items;
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)blockInfo.state.func_177230_c().func_199767_j()));
            if (blockInfo.tileEntityNBT != null && blockInfo.tileEntityNBT.func_74764_b("Items") && (items = (ListNBT)blockInfo.tileEntityNBT.func_74781_a("Items")) != null) {
                for (int i = 0; i < items.size(); ++i) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)ItemStack.func_199557_a((CompoundNBT)items.func_150305_b(i)));
                }
            }
        }
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f);
    }

    private static boolean checkChunkExists(World world, ChunkPos chunkPos) {
        return world.func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b);
    }

    public static void forceAllHeal() {
        ChunkDataHandler.toHealDimMap.forEach((key, value) -> {
            if (!dimForceHeal.containsKey(key)) {
                dimForceHeal.put((ResourceLocation)key, new HashSet());
            }
            value.forEach((key2, value2) -> dimForceHeal.get(key).add((Integer)key2));
        });
    }
}

