/*
 * Decompiled with CFR 0.152.
 */
package com.polyvalord.extcaves.blocks.basic;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockTrapSpike
extends Block {
    public static final int MAXSPIKES = 4;
    public static final IntegerProperty SPIKES = IntegerProperty.func_177719_a((String)"spikes", (int)1, (int)4);
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
    public final Set<EntityType<?>> IS_IMMUNE = ImmutableSet.of((Object)EntityType.field_200741_ag, (Object)EntityType.field_200750_ap, (Object)EntityType.field_200722_aA, (Object)EntityType.field_200725_aD, (Object)EntityType.field_200727_aF, (Object)EntityType.field_200763_C, (Object[])new EntityType[]{EntityType.field_204724_o});
    protected static final VoxelShape SHAPE_ONE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5), (VoxelShape)Block.func_208617_a((double)7.5, (double)2.0, (double)7.5, (double)8.5, (double)8.0, (double)8.5));
    private static final Map<Direction, VoxelShape> SHAPE_TWO = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.5, (double)0.0, (double)8.5, (double)8.5, (double)3.0, (double)11.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.5, (double)3.0, (double)9.5, (double)7.5, (double)8.0, (double)10.5), Block.func_208617_a((double)7.5, (double)0.0, (double)4.5, (double)10.5, (double)2.0, (double)7.5), Block.func_208617_a((double)8.5, (double)2.0, (double)5.5, (double)9.5, (double)8.0, (double)6.5)}), (Object)Direction.EAST, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.5, (double)0.0, (double)5.5, (double)7.5, (double)3.0, (double)8.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.5, (double)3.0, (double)6.5, (double)6.5, (double)8.0, (double)7.5), Block.func_208617_a((double)8.5, (double)0.0, (double)7.5, (double)11.5, (double)2.0, (double)10.5), Block.func_208617_a((double)9.5, (double)2.0, (double)8.5, (double)10.5, (double)8.0, (double)9.5)}), (Object)Direction.SOUTH, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.5, (double)0.0, (double)4.5, (double)10.5, (double)3.0, (double)7.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)8.5, (double)3.0, (double)5.5, (double)9.5, (double)8.0, (double)6.5), Block.func_208617_a((double)5.5, (double)0.0, (double)8.5, (double)8.5, (double)2.0, (double)11.5), Block.func_208617_a((double)6.5, (double)2.0, (double)9.5, (double)7.5, (double)8.0, (double)10.5)}), (Object)Direction.WEST, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)8.5, (double)0.0, (double)7.5, (double)11.5, (double)3.0, (double)10.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)9.5, (double)3.0, (double)8.5, (double)10.5, (double)8.0, (double)9.5), Block.func_208617_a((double)4.5, (double)0.0, (double)5.5, (double)7.5, (double)2.0, (double)8.5), Block.func_208617_a((double)5.5, (double)2.0, (double)6.5, (double)6.5, (double)8.0, (double)7.5)})));
    private static final Map<Direction, VoxelShape> SHAPE_THREE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.5, (double)0.0, (double)7.5, (double)7.5, (double)3.0, (double)10.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.5, (double)3.0, (double)8.5, (double)6.5, (double)8.0, (double)9.5), Block.func_208617_a((double)6.5, (double)0.0, (double)3.5, (double)9.5, (double)2.0, (double)6.5), Block.func_208617_a((double)9.5, (double)2.0, (double)10.5, (double)10.5, (double)8.0, (double)11.5), Block.func_208617_a((double)8.5, (double)0.0, (double)9.5, (double)11.5, (double)2.0, (double)12.5), Block.func_208617_a((double)7.5, (double)2.0, (double)4.5, (double)8.5, (double)8.0, (double)5.5)}), (Object)Direction.EAST, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.5, (double)0.0, (double)4.5, (double)8.5, (double)3.0, (double)7.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.5, (double)3.0, (double)5.5, (double)7.5, (double)8.0, (double)6.5), Block.func_208617_a((double)9.5, (double)0.0, (double)6.5, (double)12.5, (double)2.0, (double)9.5), Block.func_208617_a((double)4.5, (double)2.0, (double)9.5, (double)5.5, (double)8.0, (double)10.5), Block.func_208617_a((double)3.5, (double)0.0, (double)8.5, (double)6.5, (double)2.0, (double)11.5), Block.func_208617_a((double)10.5, (double)2.0, (double)7.5, (double)11.5, (double)8.0, (double)8.5)}), (Object)Direction.SOUTH, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)8.5, (double)0.0, (double)5.5, (double)11.5, (double)3.0, (double)8.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)9.5, (double)3.0, (double)6.5, (double)10.5, (double)8.0, (double)7.5), Block.func_208617_a((double)6.5, (double)0.0, (double)9.5, (double)9.5, (double)2.0, (double)12.5), Block.func_208617_a((double)5.5, (double)2.0, (double)4.5, (double)6.5, (double)8.0, (double)5.5), Block.func_208617_a((double)4.5, (double)0.0, (double)3.5, (double)7.5, (double)2.0, (double)6.5), Block.func_208617_a((double)7.5, (double)2.0, (double)10.5, (double)8.5, (double)8.0, (double)11.5)}), (Object)Direction.WEST, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.5, (double)0.0, (double)8.5, (double)10.5, (double)3.0, (double)11.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)8.5, (double)3.0, (double)9.5, (double)9.5, (double)8.0, (double)10.5), Block.func_208617_a((double)3.5, (double)0.0, (double)6.5, (double)6.5, (double)2.0, (double)9.5), Block.func_208617_a((double)10.5, (double)2.0, (double)5.5, (double)11.5, (double)8.0, (double)6.5), Block.func_208617_a((double)9.5, (double)0.0, (double)4.5, (double)12.5, (double)2.0, (double)7.5), Block.func_208617_a((double)4.5, (double)2.0, (double)7.5, (double)5.5, (double)8.0, (double)8.5)})));
    private static final Map<Direction, VoxelShape> SHAPE_FOUR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)3.5, (double)0.0, (double)7.5, (double)6.5, (double)3.0, (double)10.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.5, (double)3.0, (double)8.5, (double)5.5, (double)8.0, (double)9.5), Block.func_208617_a((double)7.5, (double)0.0, (double)10.5, (double)10.5, (double)2.0, (double)13.5), Block.func_208617_a((double)6.5, (double)2.0, (double)3.5, (double)7.5, (double)8.0, (double)4.5), Block.func_208617_a((double)5.5, (double)0.0, (double)2.5, (double)8.5, (double)2.0, (double)5.5), Block.func_208617_a((double)8.5, (double)2.0, (double)11.5, (double)9.5, (double)8.0, (double)12.5), Block.func_208617_a((double)9.5, (double)0.0, (double)5.5, (double)12.5, (double)3.0, (double)8.5), Block.func_208617_a((double)10.5, (double)3.0, (double)6.5, (double)11.5, (double)8.0, (double)7.5)}), (Object)Direction.EAST, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.5, (double)0.0, (double)3.5, (double)8.5, (double)3.0, (double)6.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.5, (double)3.0, (double)4.5, (double)7.5, (double)8.0, (double)5.5), Block.func_208617_a((double)2.5, (double)0.0, (double)7.5, (double)5.5, (double)2.0, (double)10.5), Block.func_208617_a((double)11.5, (double)2.0, (double)6.5, (double)12.5, (double)8.0, (double)7.5), Block.func_208617_a((double)10.5, (double)0.0, (double)5.5, (double)13.5, (double)2.0, (double)8.5), Block.func_208617_a((double)3.5, (double)2.0, (double)8.5, (double)4.5, (double)8.0, (double)9.5), Block.func_208617_a((double)7.5, (double)0.0, (double)9.5, (double)10.5, (double)3.0, (double)12.5), Block.func_208617_a((double)8.5, (double)3.0, (double)10.5, (double)9.5, (double)8.0, (double)11.5)}), (Object)Direction.SOUTH, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)9.5, (double)0.0, (double)5.5, (double)12.5, (double)3.0, (double)8.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)10.5, (double)3.0, (double)6.5, (double)11.5, (double)8.0, (double)7.5), Block.func_208617_a((double)5.5, (double)0.0, (double)2.5, (double)8.5, (double)2.0, (double)5.5), Block.func_208617_a((double)8.5, (double)2.0, (double)11.5, (double)9.5, (double)8.0, (double)12.5), Block.func_208617_a((double)7.5, (double)0.0, (double)10.5, (double)10.5, (double)2.0, (double)13.5), Block.func_208617_a((double)6.5, (double)2.0, (double)3.5, (double)7.5, (double)8.0, (double)4.5), Block.func_208617_a((double)3.5, (double)0.0, (double)7.5, (double)6.5, (double)3.0, (double)10.5), Block.func_208617_a((double)4.5, (double)3.0, (double)8.5, (double)5.5, (double)8.0, (double)9.5)}), (Object)Direction.WEST, (Object)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.5, (double)0.0, (double)9.5, (double)10.5, (double)3.0, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)8.5, (double)3.0, (double)10.5, (double)9.5, (double)8.0, (double)11.5), Block.func_208617_a((double)10.5, (double)0.0, (double)5.5, (double)13.5, (double)2.0, (double)8.5), Block.func_208617_a((double)3.5, (double)2.0, (double)8.5, (double)4.5, (double)8.0, (double)9.5), Block.func_208617_a((double)2.5, (double)0.0, (double)7.5, (double)5.5, (double)2.0, (double)10.5), Block.func_208617_a((double)11.5, (double)2.0, (double)6.5, (double)12.5, (double)8.0, (double)7.5), Block.func_208617_a((double)5.5, (double)0.0, (double)3.5, (double)8.5, (double)3.0, (double)6.5), Block.func_208617_a((double)6.5, (double)3.0, (double)4.5, (double)7.5, (double)8.0, (double)5.5)})));

    public BlockTrapSpike(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)SPIKES, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        float damage = 0.5f;
        switch (worldIn.func_175659_aa()) {
            case HARD: {
                damage = 1.5f;
                break;
            }
            case NORMAL: {
                damage = 1.0f;
                break;
            }
            case EASY: {
                break;
            }
        }
        if (entityIn instanceof LivingEntity && !this.IS_IMMUNE.contains(entityIn.func_200600_R())) {
            entityIn.func_70097_a(DamageSource.field_76377_j, damage);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] adirection;
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_177230_c() == this) {
            return (BlockState)blockstate.func_206870_a((IProperty)SPIKES, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.func_177229_b((IProperty)SPIKES) + 1)));
        }
        BlockState blockstateb = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : adirection = context.func_196009_e()) {
            Direction direction1;
            if (!direction.func_176740_k().func_176722_c() || !(blockstateb = (BlockState)blockstateb.func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)(direction1 = direction.func_176734_d()))).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            return blockstateb;
        }
        return null;
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return !state.func_196952_d(worldIn, pos).func_212434_a(Direction.UP).func_197766_b();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((IProperty)SPIKES) < 4 ? true : super.func_196253_a(state, useContext);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((IProperty)SPIKES)) {
            default: {
                return SHAPE_ONE;
            }
            case 2: {
                return SHAPE_TWO.get(state.func_177229_b((IProperty)HORIZONTAL_FACING));
            }
            case 3: {
                return SHAPE_THREE.get(state.func_177229_b((IProperty)HORIZONTAL_FACING));
            }
            case 4: 
        }
        return SHAPE_FOUR.get(state.func_177229_b((IProperty)HORIZONTAL_FACING));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SPIKES, HORIZONTAL_FACING});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

