/*
 * Decompiled with CFR 0.152.
 */
package com.polyvalord.extcaves.world;

import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import com.polyvalord.extcaves.blocks.BlockTreasurePot;
import com.polyvalord.extcaves.blocks.BlockTreasurePotLong;
import com.polyvalord.extcaves.blocks.RegBlocks;
import com.polyvalord.extcaves.config.Cfg;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class FeatureCabinSpruce
extends Feature<NoFeatureConfig> {
    private final int spawnrate = (Integer)Cfg.spruce_cabins_spawnrate.get();
    private static final ResourceLocation CABIN_SPRUCE = new ResourceLocation("extcaves:cabins/cabin_spruce");
    private static final ResourceLocation[] CABINS = new ResourceLocation[]{CABIN_SPRUCE};
    public static Set<Block> VALID_GROUND = Sets.newHashSet((Object[])new Block[]{Blocks.field_150348_b, Blocks.field_196654_e, Blocks.field_196656_g, Blocks.field_196650_c, Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150403_cj, Blocks.field_205164_gk});

    public FeatureCabinSpruce(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51479_1_) {
        super(p_i51479_1_);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (this.canGenerate(rand)) {
            Random random = worldIn.func_201674_k();
            Rotation[] arotation = Rotation.values();
            Rotation rotation = arotation[random.nextInt(arotation.length)];
            int i = random.nextInt(CABINS.length);
            TemplateManager templatemanager = ((ServerWorld)worldIn.func_201672_e()).func_217485_w().func_186340_h();
            Template template = templatemanager.func_200220_a(CABINS[i]);
            BlockPos blockpos = template.func_186257_a(rotation);
            PlacementSettings placementsettingsFinal = new PlacementSettings().func_186220_a(rotation).func_189950_a(random);
            IntegrityProcessor integrityprocessorFinal = new IntegrityProcessor(1.0f);
            placementsettingsFinal.func_215219_b().func_215222_a((StructureProcessor)integrityprocessorFinal);
            BlockPos blockposFinal = template.func_189961_a(pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p()), Mirror.NONE, rotation);
            BlockPos blockposTest = pos.func_177982_a(blockpos.func_177958_n() + 3, blockpos.func_177956_o(), blockpos.func_177952_p() + 3);
            int w = 2;
            BlockPos blockposCheckA = blockposTest.func_177982_a(w, 0, w);
            BlockPos blockposCheckB = blockposTest.func_177982_a(-w, 0, -w);
            if (worldIn.func_180495_p(blockposTest.func_177984_a()).func_177230_c() == Blocks.field_201941_jj && VALID_GROUND.contains(worldIn.func_180495_p(blockposTest.func_177977_b()).func_177230_c()) && VALID_GROUND.contains(worldIn.func_180495_p(blockposCheckA.func_177977_b()).func_177230_c()) && VALID_GROUND.contains(worldIn.func_180495_p(blockposCheckB.func_177977_b()).func_177230_c())) {
                template.func_189962_a(worldIn, blockposFinal, placementsettingsFinal, 4);
                BlockState platformblock = Blocks.field_150347_e.func_176223_P();
                for (int l = 1; l < 6; ++l) {
                    for (int m = 1; m < 6; ++m) {
                        worldIn.func_180501_a(pos.func_177982_a(blockpos.func_177958_n() + l, blockpos.func_177956_o() - 1, blockpos.func_177952_p() + m), platformblock, 2);
                    }
                }
                BlockState decorationselect = RegBlocks.treasure_pot.func_176223_P();
                for (int j = 2; j < 5; ++j) {
                    for (int k = 2; k < 5; ++k) {
                        int t = rand.nextInt(3);
                        if (t != 0) continue;
                        int t2 = rand.nextInt(2);
                        block0 : switch (t2) {
                            case 0: {
                                decorationselect = (BlockState)RegBlocks.treasure_pot.func_176223_P().func_206870_a((IProperty)BlockTreasurePot.HORIZONTAL_FACING, (Comparable)this.getRandomDir(rand));
                                break;
                            }
                            case 1: {
                                int t3 = rand.nextInt(2);
                                switch (t3) {
                                    case 0: {
                                        decorationselect = (BlockState)RegBlocks.treasure_pot_short.func_176223_P().func_206870_a((IProperty)BlockTreasurePotLong.HORIZONTAL_FACING, (Comparable)this.getRandomDir(rand));
                                        break block0;
                                    }
                                    case 1: {
                                        decorationselect = (BlockState)RegBlocks.treasure_pot_long.func_176223_P().func_206870_a((IProperty)BlockTreasurePotLong.HORIZONTAL_FACING, (Comparable)this.getRandomDir(rand));
                                    }
                                }
                            }
                        }
                        worldIn.func_180501_a(pos.func_177982_a(blockpos.func_177958_n() + j, blockpos.func_177956_o() + 1, blockpos.func_177952_p() + k), decorationselect, 2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Direction getRandomDir(Random rand) {
        int t = rand.nextInt(4);
        Direction dir = Direction.NORTH;
        switch (t) {
            case 0: {
                dir = Direction.NORTH;
                break;
            }
            case 1: {
                dir = Direction.SOUTH;
                break;
            }
            case 2: {
                dir = Direction.EAST;
                break;
            }
            case 3: {
                dir = Direction.WEST;
            }
        }
        return dir;
    }

    public boolean canGenerate(Random rand) {
        int v = Math.abs(40 - this.spawnrate);
        int r = rand.nextInt(v);
        return r == 0;
    }
}

