/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.clusters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import zed.d0c.clusters.ClustersNode;
import zed.d0c.punchcards.PunchCards;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Clusters {
    private static final ClustersRegistry CLUSTERS_REGISTRY = new ClustersRegistry();

    public static ClustersRegistry getClustersRegistry() {
        return CLUSTERS_REGISTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNode(World worldIn, ClustersNode newNode) {
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            Clusters.CLUSTERS_REGISTRY.getClusterSet(worldIn).add(newNode);
        }
        PunchCards.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(World worldIn, ClustersNode exNode) {
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            Clusters.CLUSTERS_REGISTRY.getClusterSet(worldIn).remove(exNode);
        }
        PunchCards.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeSet(World worldIn, ClustersSet newNodeSet) {
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            Clusters.CLUSTERS_REGISTRY.getClusterSet(worldIn).addAll(newNodeSet);
        }
        PunchCards.setDirty();
    }

    private ClustersNode getNode(World worldIn, BlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        for (ClustersNode node : Clusters.CLUSTERS_REGISTRY.getClusterSet(worldIn)) {
            if (!node.contains(block, pos)) continue;
            return node;
        }
        ClustersNode newNode = new ClustersNode(state.func_177230_c(), pos);
        this.addNode(worldIn, newNode);
        return newNode;
    }

    public boolean applyDirectPower(World worldIn, BlockPos iPos, @Nullable ArrayList<PlayerEntity> playerList) {
        ClustersNode node = this.getNode(worldIn, worldIn.func_180495_p(iPos), iPos);
        boolean directPowerApplied = node.powerNode(worldIn, iPos, playerList);
        PunchCards.setDirty();
        return directPowerApplied;
    }

    public boolean removeDirectPower(BlockState state, World worldIn, BlockPos pos) {
        boolean blockDepowered = this.getNode(worldIn, state, pos).depowerBlock(worldIn, pos);
        PunchCards.setDirty();
        return blockDepowered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToClusters(World worldIn, BlockPos pos, BlockState state) {
        BlockPos iPos = pos.func_185334_h();
        Block block = state.func_177230_c();
        ClustersNode newNode = this.getNode(worldIn, state, iPos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            ClustersNode adjacentNode;
            BlockPos neighborPos = iPos.func_177972_a(direction);
            if (worldIn.func_180495_p(neighborPos).func_177230_c() != block || newNode.equals(adjacentNode = this.getNode(worldIn, state, neighborPos))) continue;
            ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
            synchronized (clustersRegistry) {
                newNode.absorbOtherNode(adjacentNode);
                this.removeNode(worldIn, adjacentNode);
            }
        }
        newNode.powerAsNeeded(worldIn);
        PunchCards.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromClusters(World worldIn, BlockPos iPos, BlockState state) {
        Block block = state.func_177230_c();
        boolean wasPowered = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u);
        ClustersNode thisNode = this.getNode(worldIn, state, iPos);
        int neighborCount = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = iPos.func_177972_a(direction);
            if (worldIn.func_180495_p(neighborPos).func_177230_c() != block) continue;
            ++neighborCount;
        }
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            switch (neighborCount) {
                case 0: {
                    this.removeNode(worldIn, thisNode);
                    break;
                }
                case 1: {
                    thisNode.removePos(worldIn, iPos);
                    if (!wasPowered || thisNode.isPowered()) break;
                    thisNode.depowerNode(worldIn);
                    break;
                }
                default: {
                    thisNode.removePos(worldIn, iPos);
                    this.removeNode(worldIn, thisNode);
                    ClustersSet setOfNodes = thisNode.reformNode();
                    this.addNodeSet(worldIn, setOfNodes);
                    this.removeNode(worldIn, thisNode);
                    if (!wasPowered) break;
                    for (ClustersNode nodeForPowerCheck : setOfNodes) {
                        if (nodeForPowerCheck.isPowered()) continue;
                        nodeForPowerCheck.depowerNode(worldIn);
                    }
                }
            }
        }
        PunchCards.setDirty();
    }

    public void registerUniqueID(World worldIn, BlockPos pos, BlockState state, UUID uniqueID) {
        this.getNode(worldIn, state, pos).addUniqueID(uniqueID);
    }

    public static int cmdReset(ServerWorld serverWorld) {
        int correctionCount = 0;
        for (DimensionType dim : CLUSTERS_REGISTRY.keySet()) {
            for (ClustersNode node : (ClustersSet)CLUSTERS_REGISTRY.get(dim)) {
                correctionCount += node.cmdResetNode(serverWorld);
            }
        }
        return correctionCount;
    }

    public static class ClustersRegistry
    extends HashMap<DimensionType, ClustersSet> {
        private ClustersSet getClusterSet(DimensionType key) {
            if (!this.containsKey(key)) {
                this.put(key, new ClustersSet());
            }
            return (ClustersSet)this.get(key);
        }

        private ClustersSet getClusterSet(World worldIn) {
            DimensionType key = worldIn.func_201675_m().func_186058_p();
            return this.getClusterSet(key);
        }
    }

    public static class ClustersSet
    extends HashSet<ClustersNode> {
    }
}

