/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.clusters;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.ForgeEventFactory;
import zed.d0c.clusters.Clusters;

public class ClustersNode
implements INBTSerializable<CompoundNBT> {
    private final String cnBlockType;
    private final HashSet<UUID> cnUUID_Set = new HashSet();
    private final HashMap<BlockPos, Boolean> cnNodeMap = new HashMap();
    private static final String BLOCK_TYPE_KEY = "cnBlockName";
    private static final String NODE_MAP_KEY = "cnNodeMap";
    private static final String LIST_UUID_KEY = "cnListUUID";

    ClustersNode(String blockTypeString, HashSet<UUID> uuidSet) {
        this.cnBlockType = blockTypeString;
        this.cnUUID_Set.addAll(uuidSet);
    }

    ClustersNode(Block block, BlockPos pos) {
        BlockPos iPos = pos.func_185334_h();
        this.cnBlockType = Objects.requireNonNull(block.getRegistryName()).toString();
        this.cnNodeMap.put(iPos, false);
    }

    public ClustersNode(CompoundNBT entry) {
        this.cnBlockType = entry.func_74779_i(BLOCK_TYPE_KEY);
        this.deserializeNBT(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            nbt.func_74778_a(BLOCK_TYPE_KEY, this.cnBlockType);
            if (!this.cnUUID_Set.isEmpty()) {
                ListNBT uuidLNBT = new ListNBT();
                for (UUID u : this.cnUUID_Set) {
                    CompoundNBT cNBT = new CompoundNBT();
                    cNBT.func_186854_a("", u);
                    uuidLNBT.add((Object)cNBT);
                }
                nbt.func_218657_a(LIST_UUID_KEY, (INBT)uuidLNBT);
            }
            CompoundNBT nodeMapNBT = new CompoundNBT();
            for (BlockPos key : this.cnNodeMap.keySet()) {
                nodeMapNBT.func_74757_a(Long.toString(key.func_218275_a()), this.cnNodeMap.get(key).booleanValue());
            }
            nbt.func_218657_a(NODE_MAP_KEY, (INBT)nodeMapNBT);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT entry) {
        ListNBT uuidLNBT = entry.func_150295_c(LIST_UUID_KEY, 10);
        for (int index = 0; index < uuidLNBT.size(); ++index) {
            this.cnUUID_Set.add(uuidLNBT.func_150305_b(index).func_186857_a(""));
        }
        CompoundNBT nodeMapNBT = entry.func_74775_l(NODE_MAP_KEY);
        for (String key : nodeMapNBT.func_150296_c()) {
            this.cnNodeMap.put(BlockPos.func_218283_e((long)Long.parseLong(key)), nodeMapNBT.func_74767_n(key));
        }
    }

    public String getNodeBlockType() {
        return this.cnBlockType;
    }

    boolean contains(Block block, BlockPos pos) {
        if (Objects.requireNonNull(block.getRegistryName()).toString().equals(this.cnBlockType)) {
            return this.cnNodeMap.containsKey(pos);
        }
        return false;
    }

    private void broadcastToNeighbors(World worldIn, HashSet<BlockPos> posToBroadcast) {
        BlockPos anyPos = (BlockPos)posToBroadcast.toArray()[0];
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)anyPos, (BlockState)worldIn.func_180495_p(anyPos), EnumSet.allOf(Direction.class), (boolean)false).isCanceled()) {
            return;
        }
        for (BlockPos pos : posToBroadcast) {
            BlockState state = worldIn.func_180495_p(pos);
            Block block = state.func_177230_c();
            worldIn.func_190524_a(pos.func_177976_e(), block, pos);
            worldIn.func_190524_a(pos.func_177974_f(), block, pos);
            worldIn.func_190524_a(pos.func_177977_b(), block, pos);
            worldIn.func_190524_a(pos.func_177984_a(), block, pos);
            worldIn.func_190524_a(pos.func_177978_c(), block, pos);
            worldIn.func_190524_a(pos.func_177968_d(), block, pos);
            BlockPos downPos = pos.func_177977_b();
            BlockState downState = worldIn.func_180495_p(downPos);
            Block downBlock = downState.func_177230_c();
            worldIn.func_190524_a(downPos.func_177976_e(), downBlock, downPos);
            worldIn.func_190524_a(downPos.func_177974_f(), downBlock, downPos);
            worldIn.func_190524_a(downPos.func_177977_b(), downBlock, downPos);
            worldIn.func_190524_a(downPos.func_177978_c(), downBlock, downPos);
            worldIn.func_190524_a(downPos.func_177968_d(), downBlock, downPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean powerNode(World worldIn, BlockPos iPos, @Nullable ArrayList<PlayerEntity> playerList) {
        if (!this.cnNodeMap.get(iPos).booleanValue()) {
            if (!this.cnUUID_Set.isEmpty() && playerList != null) {
                boolean playerRegistered = false;
                for (PlayerEntity player : playerList) {
                    if (!this.cnUUID_Set.contains(player.func_110124_au())) continue;
                    playerRegistered = true;
                    break;
                }
                if (!playerRegistered) {
                    return false;
                }
            }
            HashSet<BlockPos> posToIterate = new HashSet<BlockPos>(this.cnNodeMap.keySet());
            ClustersNode clustersNode = this;
            synchronized (clustersNode) {
                this.cnNodeMap.put(iPos, true);
                for (BlockPos activatePos : posToIterate) {
                    worldIn.func_180501_a(activatePos, (BlockState)worldIn.func_180495_p(activatePos).func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
            this.broadcastToNeighbors(worldIn, posToIterate);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void depowerNode(World worldIn) {
        HashSet<BlockPos> posToIterate = new HashSet<BlockPos>(this.cnNodeMap.keySet());
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            for (BlockPos deactivatePos : posToIterate) {
                BlockState oldState = worldIn.func_180495_p(deactivatePos);
                BlockState newState = (BlockState)oldState.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(deactivatePos, newState, 2);
            }
        }
        this.broadcastToNeighbors(worldIn, posToIterate);
    }

    boolean isPowered() {
        return this.cnNodeMap.containsValue(true);
    }

    boolean depowerBlock(World worldIn, BlockPos pos) {
        this.cnNodeMap.replace(pos, false);
        if (this.isPowered()) {
            return false;
        }
        this.depowerNode(worldIn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void absorbOtherNode(ClustersNode otherNode) {
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            this.cnUUID_Set.addAll(otherNode.cnUUID_Set);
            this.cnNodeMap.putAll(otherNode.cnNodeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePos(World worldIn, BlockPos pos) {
        Boolean wasPowered;
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            wasPowered = this.cnNodeMap.get(pos);
            this.cnNodeMap.remove(pos);
        }
        if (wasPowered.booleanValue() && !this.isPowered()) {
            this.depowerNode(worldIn);
        }
    }

    public Clusters.ClustersSet reformNode() {
        Clusters.ClustersSet returnDistinctNodes = new Clusters.ClustersSet();
        String blockType = this.getNodeBlockType();
        while (this.cnNodeMap.size() > 0) {
            ClustersNode newNode = new ClustersNode(blockType, this.cnUUID_Set);
            HashSet<BlockPos> posToAdd = new HashSet<BlockPos>();
            BlockPos anyKey = (BlockPos)this.cnNodeMap.keySet().toArray()[0];
            posToAdd.add(anyKey.func_185334_h());
            while (posToAdd.size() > 0) {
                BlockPos nextPos = (BlockPos)posToAdd.toArray()[0];
                posToAdd.remove(nextPos);
                newNode.cnNodeMap.put(nextPos.func_185334_h(), this.cnNodeMap.remove(nextPos));
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos adjacentPos = nextPos.func_177972_a(direction);
                    if (!this.cnNodeMap.containsKey(adjacentPos)) continue;
                    posToAdd.add(adjacentPos.func_185334_h());
                }
            }
            returnDistinctNodes.add(newNode);
        }
        return returnDistinctNodes;
    }

    public void powerAsNeeded(World worldIn) {
        if (this.isPowered()) {
            HashSet<BlockPos> poweredBPSet = new HashSet<BlockPos>();
            for (BlockPos pos : this.cnNodeMap.keySet()) {
                BlockState state = worldIn.func_180495_p(pos);
                if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) continue;
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)), 2);
                poweredBPSet.add(pos);
            }
            if (!poweredBPSet.isEmpty()) {
                this.broadcastToNeighbors(worldIn, poweredBPSet);
            }
        }
    }

    public void addUniqueID(UUID uniqueID) {
        this.cnUUID_Set.add(uniqueID);
    }

    public int cmdResetNode(ServerWorld serverWorld) {
        HashSet<BlockPos> failedPosSet = new HashSet<BlockPos>();
        for (BlockPos posToCheck : this.cnNodeMap.keySet()) {
            if (Objects.requireNonNull(serverWorld.func_180495_p(posToCheck).func_177230_c().getRegistryName()).toString().equals(this.cnBlockType)) continue;
            failedPosSet.add(posToCheck);
        }
        for (BlockPos posToCull : failedPosSet) {
            this.cnNodeMap.remove(posToCull);
        }
        return failedPosSet.size();
    }
}

