/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractPressurePlateBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import zed.d0c.clusters.Clusters;

@ParametersAreNonnullByDefault
public abstract class AbstractFloorMatBlock
extends AbstractPressurePlateBlock
implements IWaterLoggable {
    protected static final Clusters FloorMatClusters = new Clusters();
    public final Sensitivity sensitivity;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    protected AbstractFloorMatBlock(Sensitivity sensitivityIn, Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.sensitivity = sensitivityIn;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208151_D, BlockStateProperties.field_208153_F, BlockStateProperties.field_208154_G, BlockStateProperties.field_208152_E, POWERED, WATERLOGGED});
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    }

    protected void func_185507_b(IWorld worldIn, BlockPos pos) {
        if (this.field_149764_J.equals(Material.field_151575_d)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187895_gX, SoundCategory.BLOCKS, 0.3f, 0.8f);
        } else if (this.field_149764_J.equals(Material.field_151576_e)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else if (this.field_149764_J.equals(Material.field_151573_f)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187776_dp, SoundCategory.BLOCKS, 0.3f, 0.90000004f);
        }
    }

    protected void func_185508_c(IWorld worldIn, BlockPos pos) {
        if (this.field_149764_J.equals(Material.field_151575_d)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187893_gW, SoundCategory.BLOCKS, 0.3f, 0.8f);
        } else if (this.field_149764_J.equals(Material.field_151576_e)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else if (this.field_149764_J.equals(Material.field_151573_f)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187774_do, SoundCategory.BLOCKS, 0.3f, 0.90000004f);
        }
    }

    protected int func_180669_e(World worldIn, BlockPos pos) {
        BlockPos iPos = pos.func_185334_h();
        AxisAlignedBB axisalignedbb = field_185511_c.func_186670_a(iPos);
        int redstoneStrength = 0;
        ArrayList<PlayerEntity> playerList = new ArrayList<PlayerEntity>();
        block0 : switch (this.sensitivity) {
            case EVERYTHING: {
                for (Entity entity : worldIn.func_72839_b(null, axisalignedbb)) {
                    if (entity.func_145773_az()) continue;
                    redstoneStrength = 15;
                    break block0;
                }
                break;
            }
            case MOBS: {
                for (Entity entity : worldIn.func_217357_a(LivingEntity.class, axisalignedbb)) {
                    if (entity.func_145773_az()) continue;
                    redstoneStrength = 15;
                    break block0;
                }
                break;
            }
            case ENTITIES: {
                if (worldIn.func_217357_a(Entity.class, axisalignedbb).isEmpty()) break;
                redstoneStrength = 15;
                break;
            }
            case PLAYERS: {
                playerList.addAll(worldIn.func_217357_a(PlayerEntity.class, axisalignedbb));
                if (playerList.isEmpty()) break;
                redstoneStrength = 15;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.sensitivity));
            }
        }
        if (redstoneStrength != 0 && FloorMatClusters.applyDirectPower(worldIn, iPos, playerList)) {
            worldIn.func_205220_G_().func_205360_a(iPos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
        }
        return redstoneStrength;
    }

    protected int func_176576_e(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    @Nonnull
    protected BlockState func_176575_a(BlockState state, int strength) {
        return (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K) {
            this.func_180669_e(worldIn, pos);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            if (this.func_180669_e((World)worldIn, pos) > 0) {
                worldIn.func_205220_G_().func_205360_a(new BlockPos((Vec3i)pos), (Object)this, this.func_149738_a((IWorldReader)worldIn));
            } else if (FloorMatClusters.removeDirectPower(state, (World)worldIn, pos)) {
                this.func_185508_c((IWorld)worldIn, pos);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.field_72995_K && state.func_177230_c() != oldState.func_177230_c()) {
            FloorMatClusters.addToClusters(worldIn, pos, state);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos iPos = pos.func_185334_h();
        if (!worldIn.field_72995_K && state.func_177230_c() != newState.func_177230_c()) {
            FloorMatClusters.removeFromClusters(worldIn, iPos, state);
        }
        super.func_196243_a(state, worldIn, iPos, newState, isMoving);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader reader, List<ITextComponent> list, ITooltipFlag flags) {
        TranslationTextComponent trigger;
        list.add((ITextComponent)new TranslationTextComponent("", new Object[0]));
        TranslationTextComponent description = new TranslationTextComponent("info.floormats.floormat_block", new Object[0]);
        if (description.func_150256_b().func_150215_a() == null || description.func_150256_b().func_150215_a() == TextFormatting.WHITE) {
            description.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
        }
        switch (this.sensitivity) {
            case EVERYTHING: {
                trigger = new TranslationTextComponent("info.floormats.trigger.everything", new Object[0]);
                break;
            }
            case MOBS: {
                trigger = new TranslationTextComponent("info.floormats.trigger.mobs", new Object[0]);
                break;
            }
            case ENTITIES: {
                trigger = new TranslationTextComponent("info.floormats.trigger.entities", new Object[0]);
                break;
            }
            case PLAYERS: {
                trigger = new TranslationTextComponent("info.floormats.trigger.players", new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.sensitivity));
            }
        }
        list.add(description.func_150258_a("  ").func_150257_a((ITextComponent)trigger));
    }

    public boolean canConnect(BlockState state) {
        return this.getBlock().equals(state.func_177230_c());
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState bSNorth = iblockreader.func_180495_p(blockpos.func_177978_c());
        BlockState bSSouth = iblockreader.func_180495_p(blockpos.func_177968_d());
        BlockState bSWest = iblockreader.func_180495_p(blockpos.func_177976_e());
        BlockState bSEast = iblockreader.func_180495_p(blockpos.func_177974_f());
        Boolean cCNorth = this.canConnect(bSNorth);
        Boolean cCSouth = this.canConnect(bSSouth);
        Boolean cCWest = this.canConnect(bSWest);
        Boolean cCEast = this.canConnect(bSEast);
        Boolean poweredConnection = cCNorth != false && (Boolean)bSNorth.func_177229_b((IProperty)POWERED) != false || cCSouth != false && (Boolean)bSSouth.func_177229_b((IProperty)POWERED) != false || cCWest != false && (Boolean)bSWest.func_177229_b((IProperty)POWERED) != false || cCEast != false && (Boolean)bSEast.func_177229_b((IProperty)POWERED) != false;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull(super.func_196258_a(context)).func_206870_a((IProperty)BlockStateProperties.field_208151_D, (Comparable)cCNorth)).func_206870_a((IProperty)BlockStateProperties.field_208153_F, (Comparable)cCSouth)).func_206870_a((IProperty)BlockStateProperties.field_208154_G, (Comparable)cCWest)).func_206870_a((IProperty)BlockStateProperties.field_208152_E, (Comparable)cCEast)).func_206870_a((IProperty)POWERED, (Comparable)poweredConnection)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BooleanProperty stateDirection;
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        switch (facing) {
            case NORTH: {
                stateDirection = BlockStateProperties.field_208151_D;
                break;
            }
            case EAST: {
                stateDirection = BlockStateProperties.field_208152_E;
                break;
            }
            case SOUTH: {
                stateDirection = BlockStateProperties.field_208153_F;
                break;
            }
            case WEST: {
                stateDirection = BlockStateProperties.field_208154_G;
                break;
            }
            default: {
                return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
            }
        }
        return (BlockState)stateIn.func_206870_a((IProperty)stateDirection, (Comparable)Boolean.valueOf(this.canConnect(facingState)));
    }

    @Nonnull
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
            }
        }
        return false;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockPos iPos;
        if (fromPos.equals((Object)pos.func_177977_b()) && !worldIn.func_201670_d() && worldIn.func_175640_z(fromPos) && FloorMatClusters.applyDirectPower(worldIn, iPos = pos.func_185334_h(), null)) {
            worldIn.func_205220_G_().func_205360_a(iPos, (Object)this, 30);
        }
    }

    public static enum Sensitivity {
        EVERYTHING,
        MOBS,
        ENTITIES,
        PLAYERS;

    }
}

