/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.punchcards;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldSavedData;
import zed.d0c.clusters.Clusters;
import zed.d0c.clusters.ClustersNode;

public class PunchCards
extends WorldSavedData {
    private static PunchCards DECK_OF_CARDS;
    private static final String DECK_BOX_NAME = "PUNCH_CARDS_DATA";
    private static final String REGISTRY_NBT_KEY = "Registry";

    public PunchCards() {
        super(DECK_BOX_NAME);
    }

    public static String getDataName() {
        return DECK_BOX_NAME;
    }

    public static void setInstance(PunchCards pcInstance) {
        DECK_OF_CARDS = pcInstance;
        DECK_OF_CARDS.func_76185_a();
    }

    public static void setDirty() {
        if (DECK_OF_CARDS != null) {
            DECK_OF_CARDS.func_76185_a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParametersAreNonnullByDefault
    public void func_76184_a(CompoundNBT nbt) {
        Clusters.ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            Clusters.getClustersRegistry().clear();
            CompoundNBT registryNBT = nbt.func_74775_l(REGISTRY_NBT_KEY);
            for (String dimName : registryNBT.func_150296_c()) {
                DimensionType dimType = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(dimName));
                if (dimType == null) continue;
                ListNBT clustersList = registryNBT.func_150295_c(dimName, 10);
                Clusters.ClustersSet dimRegistry = new Clusters.ClustersSet();
                for (int clustersIndex = 0; clustersIndex < clustersList.size(); ++clustersIndex) {
                    CompoundNBT entry = clustersList.func_150305_b(clustersIndex);
                    dimRegistry.add(new ClustersNode(entry));
                }
                Clusters.getClustersRegistry().put(dimType, dimRegistry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ParametersAreNonnullByDefault
    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        CompoundNBT registryNBT = new CompoundNBT();
        Clusters.ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            for (DimensionType dimType : Clusters.getClustersRegistry().keySet()) {
                if (dimType == null) continue;
                ListNBT clustersList = new ListNBT();
                for (ClustersNode node : (Clusters.ClustersSet)Clusters.getClustersRegistry().get(dimType)) {
                    clustersList.add((Object)node.serializeNBT());
                }
                registryNBT.func_218657_a(Objects.requireNonNull(DimensionType.func_212678_a((DimensionType)dimType)).toString(), (INBT)clustersList);
            }
        }
        nbt.func_218657_a(REGISTRY_NBT_KEY, (INBT)registryNBT);
        return nbt;
    }
}

