/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.userdev;

import com.google.common.base.Strings;
import com.mojang.authlib.Agent;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import cpw.mods.modlauncher.Launcher;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.userdev.ArgumentList;
import org.apache.logging.log4j.LogManager;

public class LaunchTesting {
    public static void main(String ... args) throws InterruptedException {
        String markerselection = System.getProperty("forge.logging.markers", "");
        Arrays.stream(markerselection.split(",")).forEach(marker -> System.setProperty("forge.logging.marker." + marker.toLowerCase(Locale.ROOT), "ACCEPT"));
        ArgumentList lst = ArgumentList.from((String[])args);
        String target = lst.getOrDefault("launchTarget", System.getenv().get("target"));
        if (target == null) {
            throw new IllegalArgumentException("Environment variable target must be set.");
        }
        lst.putLazy("gameDir", ".");
        lst.putLazy("launchTarget", target);
        lst.putLazy("fml.mcpVersion", System.getenv("MCP_VERSION"));
        lst.putLazy("fml.mcVersion", System.getenv("MC_VERSION"));
        lst.putLazy("fml.forgeGroup", System.getenv("FORGE_GROUP"));
        lst.putLazy("fml.forgeVersion", System.getenv("FORGE_VERSION"));
        if (target.contains("client")) {
            LaunchTesting.hackNatives();
            lst.putLazy("version", "MOD_DEV");
            lst.putLazy("assetIndex", System.getenv("assetIndex"));
            lst.putLazy("assetsDir", System.getenv().getOrDefault("assetDirectory", "assets"));
            String assets = lst.get("assetsDir");
            if (assets == null || !new File(assets).exists()) {
                throw new IllegalArgumentException("Environment variable 'assetDirectory' must be set to a valid path.");
            }
            if (!lst.hasValue("accessToken") && !LaunchTesting.login(lst)) {
                String username = lst.get("username");
                if (username != null) {
                    Matcher m = Pattern.compile("#+").matcher(username);
                    StringBuffer replaced = new StringBuffer();
                    while (m.find()) {
                        m.appendReplacement(replaced, LaunchTesting.getRandomNumbers(m.group().length()));
                    }
                    m.appendTail(replaced);
                    lst.put("username", replaced.toString());
                } else {
                    lst.putLazy("username", "kapiteon");
                }
                lst.put("accessToken", "DONT_CRASH");
                lst.put("userProperties", "{}");
            }
        }
        if (!Arrays.asList("fmldevclient", "fmldevserver", "fmldevdata", "fmluserdevclient", "fmluserdevserver", "fmluserdevdata").contains(target)) {
            throw new IllegalArgumentException("Unknown value for 'target' property: " + target);
        }
        Launcher.main((String[])lst.getArguments());
        Thread.sleep(10000L);
    }

    private static String getRandomNumbers(int length) {
        return Long.toString(System.nanoTime() % (long)((int)Math.pow(10.0, length)));
    }

    private static void hackNatives() {
        String paths = System.getProperty("java.library.path");
        String nativesDir = System.getenv().get("nativesDirectory");
        paths = Strings.isNullOrEmpty((String)paths) ? nativesDir : paths + File.pathSeparator + nativesDir;
        System.setProperty("java.library.path", paths);
        try {
            Method initializePathMethod = ClassLoader.class.getDeclaredMethod("initializePath", String.class);
            initializePathMethod.setAccessible(true);
            Object usrPathsValue = initializePathMethod.invoke(null, "java.library.path");
            Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
            usrPathsField.setAccessible(true);
            usrPathsField.set(null, usrPathsValue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean login(ArgumentList args) {
        if (!args.hasValue("username") || !args.hasValue("password")) {
            args.remove("password");
            return false;
        }
        UserAuthentication auth = new YggdrasilAuthenticationService(Proxy.NO_PROXY, "1").createUserAuthentication(Agent.MINECRAFT);
        auth.setUsername(args.get("username"));
        auth.setPassword(args.remove("password"));
        try {
            auth.logIn();
        }
        catch (AuthenticationException e) {
            LogManager.getLogger().error("Login failed!", (Throwable)e);
            throw new RuntimeException(e);
        }
        args.put("username", auth.getSelectedProfile().getName());
        args.put("uuid", auth.getSelectedProfile().getId().toString().replace("-", ""));
        args.put("accessToken", auth.getAuthenticatedToken());
        args.put("userProperties", auth.getUserProperties().toString());
        return true;
    }
}

