/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.cherry.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.stream.Stream;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PetalParticle
extends SpriteTexturedParticle {
    private float angleStepX;
    private float angleStepZ;
    private Vector3f vForce;
    private float particleAngleX;
    private float prevParticleAngleX;
    private boolean inWater;

    private PetalParticle(ClientWorld world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.field_70547_e = 100;
        this.field_70546_d = this.field_187136_p.nextInt(20);
        this.field_70544_f = 0.75f + this.field_187136_p.nextFloat() * 0.25f;
        this.field_82339_as = 0.7f + this.field_187136_p.nextFloat() * 0.3f;
        float baseMotionX = 0.2f + this.field_187136_p.nextFloat() * 0.06f;
        float baseMotionY = -0.5f;
        float baseMotionZ = 0.3f + this.field_187136_p.nextFloat() * 0.06f;
        Vector3f motion = new Vector3f(baseMotionX, baseMotionY, baseMotionZ);
        motion.func_229194_d_();
        this.vForce = new Vector3f(baseMotionZ, 0.0f, -baseMotionX);
        Quaternion rot = this.vForce.func_229187_a_(-90.0f);
        this.vForce = motion.func_229195_e_();
        this.vForce.func_214905_a(rot);
        motion.func_195898_a(0.1f + this.field_187136_p.nextFloat() * 0.05f);
        this.field_187129_i = motion.func_195899_a();
        this.field_187130_j = motion.func_195900_b();
        this.field_187131_k = motion.func_195902_c();
        this.angleStepX = this.field_187136_p.nextFloat() * 0.1f;
        this.angleStepZ = this.field_187136_p.nextFloat() * 0.1f;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public float func_217561_b(float pTicks) {
        if (this.field_70547_e - this.field_70546_d < 10) {
            float f = MathHelper.func_76126_a((float)((float)((double)(((float)(this.field_70547_e - this.field_70546_d) - pTicks) / 20.0f) * Math.PI)));
            f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
            return f;
        }
        return 1.0f;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_190015_G = this.field_190014_F;
        this.prevParticleAngleX = this.particleAngleX;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
        boolean lastOnGround = this.field_187132_l;
        if (!this.field_187132_l && !this.inWater) {
            float mul = this.field_70546_d % 10 < 5 ? 0.03f : -0.03f;
            this.field_187129_i += (double)(this.vForce.func_195899_a() * mul);
            this.field_187130_j += (double)(this.vForce.func_195900_b() * mul);
            this.field_187131_k += (double)(this.vForce.func_195902_c() * mul);
            this.field_190014_F += this.angleStepZ;
            this.particleAngleX += this.angleStepX;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187132_l) {
            if (this.field_187132_l && !lastOnGround) {
                this.field_70546_d = this.field_70547_e - 20;
            }
            this.field_187129_i *= 0.5;
            this.field_187131_k *= 0.5;
        } else if (this.inWater) {
            this.field_187129_i *= 0.66;
            this.field_187131_k *= 0.66;
        } else {
            if (lastOnGround) {
                this.field_70546_d = this.field_70547_e - 60;
            }
            this.field_187129_i *= 1.001;
            this.field_187130_j *= 0.998;
            this.field_187131_k *= 1.001;
        }
    }

    public void func_187110_a(double x, double y, double z) {
        int ix = (int)this.field_187126_f;
        int iy = (int)this.field_187127_g;
        int iz = (int)this.field_187128_h;
        Chunk chunk = this.field_187122_b.func_212866_a_(ix >> 4, iz >> 4);
        FluidState fluidState = chunk.func_205751_b(ix, iy, iz);
        float height = fluidState.func_223408_f();
        if (fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) {
            if (!this.inWater && this.field_187127_g <= (double)(height + (float)iy)) {
                this.inWater = true;
                this.field_70546_d -= 60;
                this.field_187130_j = 0.0;
                this.field_187124_d = this.field_187127_g = (double)(height + (float)iy);
            }
            if (this.inWater) {
                Vector3d flow = fluidState.func_215673_c((IBlockReader)this.field_187122_b, new BlockPos(ix, iy, iz));
                this.field_187129_i += flow.field_72450_a * 0.02;
                this.field_187131_k += flow.field_72449_c * 0.02;
                x = this.field_187129_i;
                z = this.field_187131_k;
            }
        } else if (this.inWater) {
            // empty if block
        }
        double lastX = x;
        double lastY = y;
        double lastZ = z;
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            Vector3d moveVec = Entity.func_223307_a((Entity)null, (Vector3d)new Vector3d(x, y, z), (AxisAlignedBB)this.func_187116_l(), (World)this.field_187122_b, (ISelectionContext)ISelectionContext.func_216377_a(), (ReuseableStream)new ReuseableStream(Stream.empty()));
            x = moveVec.field_72450_a;
            y = moveVec.field_72448_b;
            z = moveVec.field_72449_c;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            if (this.inWater) {
                double targetY = height + (float)iy;
                y = MathHelper.func_151237_a((double)(targetY - this.field_187127_g), (double)-0.005, (double)0.02);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
            this.func_187118_j();
        }
        if (Math.abs(lastY) >= (double)1.0E-5f && Math.abs(y) < (double)1.0E-5f) {
            this.field_228343_B_ = true;
        }
        if (!this.inWater) {
            boolean bl = this.field_187132_l = lastY != y && lastY < 0.0;
        }
        if (lastX != x) {
            this.field_187129_i = 0.0;
        }
        if (lastZ != z) {
            this.field_187131_k = 0.0;
        }
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d vec3d = renderInfo.func_216785_c();
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vec3d.func_82615_a());
        float f1 = (float)(-vec3d.func_82617_b());
        f1 = this.inWater ? (float)((double)f1 + this.field_187127_g) : (float)((double)f1 + MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g));
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vec3d.func_82616_c());
        Quaternion quaternion = new Quaternion(renderInfo.func_227995_f_());
        float rx = MathHelper.func_219799_g((float)partialTicks, (float)this.prevParticleAngleX, (float)this.particleAngleX);
        float rz = MathHelper.func_219799_g((float)partialTicks, (float)this.field_190015_G, (float)this.field_190014_F);
        if (this.field_187132_l || this.inWater) {
            quaternion = Vector3f.field_229179_b_.func_229187_a_(90.0f);
            f1 = this.inWater ? (float)((double)f1 + ((double)0.16f + (double)rz % 0.01)) : (float)((double)f1 + ((double)0.005f + (double)rz % 0.01));
        } else {
            quaternion = new Quaternion(renderInfo.func_227995_f_());
            quaternion.func_195890_a(Vector3f.field_229179_b_.func_229193_c_(rx));
        }
        quaternion.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(rz));
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.func_217561_b(partialTicks);
        float alpha = f4 * this.field_82339_as;
        f4 *= this.field_70544_f * 0.15f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(f, f1, f2);
        }
        float f7 = this.func_217563_c();
        float f8 = this.func_217564_d();
        float f5 = this.func_217562_e();
        float f6 = this.func_217560_f();
        int j = this.func_189214_a(partialTicks);
        buffer.func_225582_a_((double)avector3f[0].func_195899_a(), (double)avector3f[0].func_195900_b(), (double)avector3f[0].func_195902_c()).func_225583_a_(f8, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[1].func_195899_a(), (double)avector3f[1].func_195900_b(), (double)avector3f[1].func_195902_c()).func_225583_a_(f8, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[2].func_195899_a(), (double)avector3f[2].func_195900_b(), (double)avector3f[2].func_195902_c()).func_225583_a_(f7, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[3].func_195899_a(), (double)avector3f[3].func_195900_b(), (double)avector3f[3].func_195902_c()).func_225583_a_(f7, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_227886_a_(j).func_181675_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PetalParticle noteparticle = new PetalParticle(worldIn, x, y, z);
            noteparticle.func_217568_a(this.spriteSet);
            return noteparticle;
        }
    }
}

