/*
 * Decompiled with CFR 0.152.
 */
package com.biom4st3r.fryingpan;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.fabricmc.loader.api.FabricLoader;

public class BioLogger {
    protected Logger logger;
    private static ConsoleHandler ch = new ConsoleHandler();
    public static final String BLACK = "\u001b[0;30m";
    public static final String RED = "\u001b[0;31m";
    public static final String GREEN = "\u001b[0;32m";
    public static final String YELLOW = "\u001b[0;33m";
    public static final String BLUE = "\u001b[0;34m";
    public static final String PURPLE = "\u001b[0;35m";
    public static final String CYAN = "\u001b[0;36m";
    public static final String WHITE = "\u001b[0;37m";

    public BioLogger(String MODID) {
        this.logger = Logger.getLogger(MODID);
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(ch);
        ch.setLevel(Level.ALL);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.logger.setLevel(Level.ALL);
        } else {
            this.logger.setLevel(Level.INFO);
        }
    }

    public static Logger createLogger(String MODID) {
        Logger tlog = Logger.getLogger(MODID);
        tlog.setUseParentHandlers(false);
        tlog.addHandler(ch);
        ch.setLevel(Level.ALL);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            tlog.setLevel(Level.ALL);
        } else {
            tlog.setLevel(Level.INFO);
        }
        return tlog;
    }

    public void setDebug(Level lvl) {
        this.logger.setLevel(lvl);
    }

    public void lesserDebug(String format, Object ... args) {
        this.logger.fine(String.format(format, args));
    }

    public void debug(String format, Object ... args) {
        this.logger.config(String.format(format, args));
    }

    public void log(String format, Object ... args) {
        this.logger.info(String.format(format, args));
    }

    public void error(String format, Object ... args) {
        this.logger.warning(String.format(format, args));
    }

    static {
        ch.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord lr) {
                String color;
                Thread thread = Thread.currentThread();
                switch (lr.getLevel().intValue()) {
                    case 600: {
                        color = BioLogger.BLUE;
                        break;
                    }
                    case 700: {
                        color = BioLogger.GREEN;
                        break;
                    }
                    case 800: {
                        color = BioLogger.WHITE;
                        break;
                    }
                    case 900: {
                        color = BioLogger.RED;
                        break;
                    }
                    default: {
                        color = BioLogger.YELLOW;
                    }
                }
                String output = String.format(color + "[%s/%s][%s] %s", thread.getName(), lr.getLevel() != Level.CONFIG ? lr.getLevel() : "DEBUG", lr.getLoggerName(), lr.getMessage());
                return output.replace("\n", "\n" + color) + "\n";
            }
        });
    }
}

