/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.core.block;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public interface IProjectileDispenserBehaviour
extends IBehaviorDispenseItem {
    default public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
        ItemStack itemStack = this.dispenseStack(source, stack);
        this.playDispenseSound(source);
        this.spawnDispenseParticles(source, (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
        return itemStack;
    }

    default public void playDispenseSound(IBlockSource source) {
        source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
    }

    default public void spawnDispenseParticles(IBlockSource source, EnumFacing facingIn) {
        source.func_82618_k().func_175718_b(2000, source.func_180699_d(), this.getWorldEventDataFrom(facingIn));
    }

    default public int getWorldEventDataFrom(EnumFacing facingIn) {
        return facingIn.func_82601_c() + 1 + (facingIn.func_82599_e() + 1) * 3;
    }

    default public ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
        World worldIn = source.func_82618_k();
        IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)source);
        EnumFacing enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        IProjectile iprojectile = this.getProjectileEntity(worldIn, iposition, stack);
        iprojectile.func_70186_c((double)enumfacing.func_82601_c(), (double)((float)enumfacing.func_96559_d() + 0.1f), (double)enumfacing.func_82599_e(), this.getProjectileVelocity(), this.getProjectileInaccuracy());
        worldIn.func_72838_d((Entity)iprojectile);
        stack.func_190918_g(1);
        return stack;
    }

    public IProjectile getProjectileEntity(World var1, IPosition var2, ItemStack var3);

    default public float getProjectileInaccuracy() {
        return 6.0f;
    }

    default public float getProjectileVelocity() {
        return 1.1f;
    }
}

