/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.asm;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import kotlin.collections.CollectionsKt;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thedarkcolour.core.util.UtilKt;
import thedarkcolour.futuremc.compat.Compat;
import vazkii.quark.api.ClassTransformer;

public final class CoreTransformer
implements IClassTransformer {
    static boolean isObfuscated;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        try {
            switch (transformedName) {
                case "net.minecraft.client.renderer.EntityRenderer": {
                    return CoreTransformer.patchEntityRenderer(basicClass);
                }
                case "net.minecraft.world.gen.feature.WorldGenTrees": {
                    return CoreTransformer.patchWorldGenTrees(basicClass);
                }
                case "net.minecraft.world.gen.feature.WorldGenBigTree": {
                    return CoreTransformer.patchWorldGenBigTree(basicClass);
                }
                case "net.minecraft.block.BlockPistonBase": {
                    try {
                        Class.forName("vazkii.quark.base.asm.LoadingPlugin");
                    }
                    catch (ClassNotFoundException e) {
                        return ClassTransformer.transformBlockPistonBase(basicClass);
                    }
                    return basicClass;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            return basicClass;
        }
        return basicClass;
    }

    private static byte[] patchEntityRenderer(byte[] basicClass) {
        if (Compat.checkVivecraft()) {
            return basicClass;
        }
        ClassNode classNode = CoreTransformer.createClassNode(basicClass);
        MethodNode method = CoreTransformer.findMethod(classNode, "func_175068_a", "renderWorldPass", null);
        MethodInsnNode target = CoreTransformer.findMethodInsn(method, "func_70055_a", "isInsideOfMaterial", null);
        method.instructions.remove(target.getPrevious().getPrevious());
        method.instructions.remove(target.getPrevious());
        method.instructions.remove(method.instructions.get(method.instructions.indexOf((AbstractInsnNode)target) + 1));
        method.instructions.remove((AbstractInsnNode)target);
        return CoreTransformer.compile(classNode);
    }

    private static byte[] patchWorldGenTrees(byte[] basicClass) {
        ClassNode classNode = CoreTransformer.createClassNode(basicClass);
        MethodNode method = CoreTransformer.findMethod(classNode, "func_180709_b", "generate", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)Z");
        InsnList toAdd = UtilKt.make(new InsnList(), list2 -> {
            list2.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list2.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list2.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list2.add((AbstractInsnNode)new VarInsnNode(21, 4));
            list2.add((AbstractInsnNode)new MethodInsnNode(184, "thedarkcolour/futuremc/world/gen/feature/BeeNestGenerator", "generateBeeNestsForSmallTrees", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;I)V", false));
        });
        return CoreTransformer.patchBeforeReturnTrue(classNode, method, toAdd);
    }

    private static byte[] patchWorldGenBigTree(byte[] basicClass) {
        ClassNode classNode = CoreTransformer.createClassNode(basicClass);
        MethodNode method = CoreTransformer.findMethod(classNode, "func_180709_b", "generate", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)Z");
        InsnList toAdd = UtilKt.make(new InsnList(), list2 -> {
            list2.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list2.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list2.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list2.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list2.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/feature/WorldGenBigTree", isObfuscated ? "field_76501_f" : "height", "I"));
            list2.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list2.add((AbstractInsnNode)new MethodInsnNode(184, "thedarkcolour/futuremc/world/gen/feature/BeeNestGenerator", "generateBeeNestsForBigTrees", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/gen/feature/WorldGenAbstractTree;)V", false));
        });
        return CoreTransformer.patchBeforeReturnTrue(classNode, method, toAdd);
    }

    private static byte[] patchModelBiped(byte[] basicClass) {
        ClassNode classNode = CoreTransformer.createClassNode(basicClass);
        MethodNode method = CoreTransformer.findMethod(classNode, "func_78087_a", "setRotationAngles", "(FFFFFFLnet/minecraft/entity/Entity;)V");
        InsnList toAdd = UtilKt.make(new InsnList(), list2 -> {
            list2.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list2.add((AbstractInsnNode)new MethodInsnNode(184, "thedarkcolour/futuremc/event/Events", "setPlayerRotations", "(Lnet/minecraft/client/model/ModelBiped;)V", false));
        });
        return CoreTransformer.patchBeforeMcMethod(classNode, method, toAdd, "func_178685_a", "copyModelAngles", 1);
    }

    private static byte[] patchRenderItem(byte[] basicClass) {
        ClassNode classNode = CoreTransformer.createClassNode(basicClass);
        MethodNode method = CoreTransformer.findMethod(classNode, "func_181564_a", "renderItem", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType;)V");
        return basicClass;
    }

    private static ClassNode createClassNode(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private static MethodNode findMethod(ClassNode classNode, String srgName, String mcpName, @Nullable String desc) {
        String actualName = isObfuscated ? srgName : mcpName;
        MethodNode method = (MethodNode)CollectionsKt.firstOrNull((List)CollectionsKt.filter((Iterable)classNode.methods, node -> node.name.equals(actualName) && (desc == null || node.desc.equals(desc))));
        if (method != null) {
            return method;
        }
        System.err.println("******************************");
        System.err.println("REPORT THIS TO FUTUREMC GITHUB");
        System.err.println("******************************");
        throw new NoSuchMethodError("Class bytecode did not contain expected method " + srgName + " or " + mcpName + " (expected: " + actualName + ")");
    }

    private static byte[] patchBeforeReturnTrue(ClassNode classNode, MethodNode method, InsnList toAdd) {
        return CoreTransformer.patchBeforeInsn(classNode, method, toAdd, 1, node -> node.getOpcode() == 172 && node.getPrevious().getOpcode() == 4);
    }

    private static byte[] patchBeforeMcMethod(ClassNode classNode, MethodNode method, InsnList toAdd, String srgName, String mcpName, int occurrence) {
        return CoreTransformer.patchBeforeInsn(classNode, method, toAdd, occurrence, node -> {
            String actualName;
            String string = actualName = isObfuscated ? srgName : mcpName;
            if (node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                return methodNode.name.equals(actualName);
            }
            return false;
        });
    }

    private static byte[] patchBeforeInsn(ClassNode classNode, MethodNode method, InsnList toAdd, int occurrence, Predicate<AbstractInsnNode> condition) {
        int[] occurrences = new int[]{0};
        AbstractInsnNode insn = CoreTransformer.findInsn(method, condition.and(node -> {
            occurrences[0] = occurrences[0] + 1;
            return occurrences[0] == occurrence;
        }));
        method.instructions.insertBefore(insn, toAdd);
        return CoreTransformer.compile(classNode);
    }

    private static MethodInsnNode findMethodInsn(MethodNode methodNode, String srgName, String mcpName, @Nullable String desc) {
        String actualName = isObfuscated ? srgName : mcpName;
        AbstractInsnNode insn = CoreTransformer.findInsn(methodNode, node -> {
            if (node instanceof MethodInsnNode) {
                MethodInsnNode method = (MethodInsnNode)node;
                return method.name.equals(actualName) && (desc == null || desc.equals(method.name));
            }
            return false;
        });
        return (MethodInsnNode)insn;
    }

    private static AbstractInsnNode findInsn(MethodNode methodNode, Predicate<AbstractInsnNode> condition) {
        for (AbstractInsnNode node : methodNode.instructions.toArray()) {
            if (!condition.test(node)) continue;
            return node;
        }
        throw new RuntimeException("Could not find matching instruction in bytecode");
    }

    private static byte[] compile(ClassNode classNode) {
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

