/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.compat.crafttweaker.CraftTweakerUtilKt;
import thedarkcolour.futuremc.recipe.smithing.SmithingRecipe;
import thedarkcolour.futuremc.recipe.smithing.SmithingRecipes;

@ZenRegister
@ZenClass(value="mods.futuremc.SmithingTable")
public final class SmithingTable {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack material, IItemStack result) {
        CraftTweakerUtilKt.applyAction(new AddAction(input, material, result));
    }

    @ZenMethod
    public static void addRecipe(IOreDictEntry input, IOreDictEntry material, IItemStack result) {
        for (IItemStack a : input.getItems()) {
            for (IItemStack b : material.getItems()) {
                CraftTweakerUtilKt.applyAction(new AddAction(a, b, result));
            }
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input, IItemStack material) {
        CraftTweakerUtilKt.applyAction(new RemoveAction(input, material));
    }

    @ZenMethod
    public static void clearDefaults() {
        SmithingRecipes.INSTANCE.getRecipes().clear();
    }

    private static final class RemoveAction
    implements IAction {
        private Runnable remove = () -> SmithingRecipes.INSTANCE.removeRecipe(CraftTweakerUtilKt.toItemStack(input), CraftTweakerUtilKt.toItemStack(material));

        private RemoveAction(IItemStack input, IItemStack material) {
        }

        public void apply() {
            this.remove.run();
            this.remove = null;
        }

        public String describe() {
            return "Removed a recipe from the smithing table";
        }
    }

    private static final class AddAction
    implements IAction {
        private final ItemStack input;
        private final ItemStack material;
        private final ItemStack result;

        private AddAction(IItemStack input, IItemStack material, IItemStack result) {
            this.input = CraftTweakerUtilKt.toItemStack(input);
            this.material = CraftTweakerUtilKt.toItemStack(material);
            this.result = CraftTweakerUtilKt.toItemStack(result);
        }

        public void apply() {
            SmithingRecipes.INSTANCE.getRecipes().add(new SmithingRecipe(this.input, this.material, this.result));
        }

        public String describe() {
            return "Added a recipe for the smithing table - Input: " + this.input + ", Material: , Output: " + this.result;
        }
    }
}

