/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.recipe.furnace.SmokerRecipes;

@ZenRegister
@ZenClass(value="mods.futuremc.Smoker")
public final class Smoker {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new AddRecipe(input, output));
    }

    @ZenMethod
    public static void addRecipe(IOreDictEntry input, IItemStack output) {
        for (IItemStack i2 : input.getItems()) {
            Smoker.addRecipe(i2, output);
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new RemoveRecipe(input));
    }

    @ZenMethod
    public static void clearRecipes() {
        SmokerRecipes.INSTANCE.clear();
    }

    private static final class RemoveRecipe
    implements IAction {
        private final ItemStack input;

        private RemoveRecipe(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            SmokerRecipes.INSTANCE.removeRecipe(this.input);
        }

        public String describe() {
            return "Removed " + this.input.func_77973_b().getRegistryName() + " from smeltable item Smoker";
        }
    }

    private static final class AddRecipe
    implements IAction {
        private final ItemStack input;
        private final ItemStack output;

        private AddRecipe(IItemStack input, IItemStack output) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            SmokerRecipes.INSTANCE.addRecipe(this.input, this.output);
        }

        public String describe() {
            return "Adding Smoker recipe (input: " + this.input.toString() + ") -> (output: " + this.output.toString() + ")";
        }
    }
}

