/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.jei.smoker;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thedarkcolour.futuremc.compat.jei.SimpleRecipeWrapper;
import thedarkcolour.futuremc.registry.FBlocks;

public class SmokerRecipeCategory
implements IRecipeCategory<SimpleRecipeWrapper> {
    public static final String NAME = "container.jei.futuremc.smoker.name";
    private final IDrawable background;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableAnimated arrow;
    private final IDrawable icon;
    private final String localizedName;

    public SmokerRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 0, 114, 82, 54);
        IDrawableStatic staticFlame = helper.createDrawable(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 82, 114, 14, 14);
        this.animatedFlame = helper.createAnimatedDrawable(staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = helper.drawableBuilder(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 82, 128, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((Block)FBlocks.SMOKER));
        this.localizedName = I18n.func_135052_a((String)"gui.jei.category.smelting", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(Minecraft minecraft) {
        this.animatedFlame.draw(minecraft, 1, 20);
        this.arrow.draw(minecraft, 24, 18);
    }

    public String getUid() {
        return NAME;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "futuremc";
    }

    public void setRecipe(IRecipeLayout recipeLayout, SimpleRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(1, false, 60, 18);
        guiItemStacks.set(ingredients);
    }
}

