/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.bee.ai;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.block.buzzybees.BeeHiveBlock;
import thedarkcolour.futuremc.entity.bee.BeeEntity;
import thedarkcolour.futuremc.entity.bee.ai.GoToBlockAI;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\rH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lthedarkcolour/futuremc/entity/bee/ai/GoToHiveAI;", "Lthedarkcolour/futuremc/entity/bee/ai/GoToBlockAI;", "bee", "Lthedarkcolour/futuremc/entity/bee/BeeEntity;", "(Lthedarkcolour/futuremc/entity/bee/BeeEntity;)V", "path", "Lnet/minecraft/pathfinding/Path;", "possibleHives", "Ljava/util/ArrayList;", "Lnet/minecraft/util/math/BlockPos;", "getPossibleHives", "()Ljava/util/ArrayList;", "addPossibleHive", "", "pos", "canBeeStart", "", "isCloseEnough", "makeChosenHivePossibleHive", "reset", "startMovingToFar", "updateTask", "future-mc"})
public final class GoToHiveAI
extends GoToBlockAI {
    private Path path;
    @NotNull
    private final ArrayList<BlockPos> possibleHives;

    @NotNull
    public final ArrayList<BlockPos> getPossibleHives() {
        return this.possibleHives;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canBeeStart() {
        BlockPos blockPos = this.getBee().getHivePos();
        if (blockPos == null) return false;
        BlockPos hivePos = blockPos;
        if (!this.getBee().func_110175_bO()) return false;
        if (!this.getBee().canEnterHive()) return false;
        if (this.isCloseEnough(hivePos)) return false;
        IBlockState iBlockState = this.getBee().field_70170_p.func_180495_p(hivePos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"bee.world.getBlockState(hivePos)");
        if (!(iBlockState.func_177230_c() instanceof BeeHiveBlock)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_75246_d() {
        BlockPos hivePos = this.getBee().getHivePos();
        if (hivePos == null) return;
        GoToHiveAI goToHiveAI = this;
        goToHiveAI.setSearchingTicks(goToHiveAI.getSearchingTicks() + 1);
        goToHiveAI.getSearchingTicks();
        if (this.getSearchingTicks() > 600) {
            this.addPossibleHive(hivePos);
            return;
        }
        if (!this.getBee().func_70661_as().func_75500_f()) return;
        if (!this.getBee().isWithinDistance(hivePos, 16)) {
            if (this.getBee().isTooFar(hivePos)) {
                this.reset();
                return;
            } else {
                this.startMovingTo(hivePos);
            }
            return;
        }
        boolean flag = this.startMovingToFar(hivePos);
        if (!flag) {
            this.makeChosenHivePossibleHive();
            return;
        }
        if (this.path != null) {
            PathNavigate pathNavigate = this.getBee().func_70661_as();
            Intrinsics.checkExpressionValueIsNotNull((Object)pathNavigate, (String)"bee.navigator");
            Path path = pathNavigate.func_75505_d();
            if (path != null) {
                Path path2 = this.path;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                if (path.func_75876_a(path2)) {
                    this.reset();
                    return;
                }
            }
        }
        PathNavigate pathNavigate = this.getBee().func_70661_as();
        Intrinsics.checkExpressionValueIsNotNull((Object)pathNavigate, (String)"bee.navigator");
        this.path = pathNavigate.func_75505_d();
    }

    private final boolean startMovingToFar(BlockPos pos) {
        this.getBee().func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0);
        PathNavigate pathNavigate = this.getBee().func_70661_as();
        Intrinsics.checkExpressionValueIsNotNull((Object)pathNavigate, (String)"bee.navigator");
        return pathNavigate.func_75505_d() != null;
    }

    private final void makeChosenHivePossibleHive() {
        BlockPos hivePos = this.getBee().getHivePos();
        if (hivePos != null) {
            this.addPossibleHive(hivePos);
        }
        this.reset();
    }

    private final void reset() {
        this.getBee().setHivePos(null);
        this.getBee().setFindHiveCooldown(200);
    }

    private final boolean isCloseEnough(BlockPos pos) {
        boolean bl;
        if (this.getBee().isWithinDistance(pos, 2)) {
            bl = true;
        } else {
            PathNavigate pathNavigate = this.getBee().func_70661_as();
            Intrinsics.checkExpressionValueIsNotNull((Object)pathNavigate, (String)"bee.navigator");
            Path path = pathNavigate.func_75505_d();
            bl = path != null && Intrinsics.areEqual((Object)path.func_189964_i(), (Object)pos) && path.func_75879_b();
        }
        return bl;
    }

    private final void addPossibleHive(BlockPos pos) {
        this.possibleHives.add(pos);
        while (this.possibleHives.size() > 3) {
            this.possibleHives.remove(0);
        }
    }

    public GoToHiveAI(@NotNull BeeEntity bee) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)bee), (String)"bee");
        super(bee);
        this.possibleHives = new ArrayList(3);
    }
}

