/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.bee.ai;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.entity.bee.BeeEntity;
import thedarkcolour.futuremc.entity.bee.ai.PassiveAI;
import thedarkcolour.futuremc.registry.FSounds;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lthedarkcolour/futuremc/entity/bee/ai/PollinateAI;", "Lthedarkcolour/futuremc/entity/bee/ai/PassiveAI;", "bee", "Lthedarkcolour/futuremc/entity/bee/BeeEntity;", "(Lthedarkcolour/futuremc/entity/bee/BeeEntity;)V", "isRunning", "", "()Z", "setRunning", "(Z)V", "lastPollinationTicks", "", "nextTarget", "Lnet/minecraft/util/math/Vec3d;", "pollinationTicks", "ticks", "canBeeContinue", "canBeeStart", "completedPollination", "getFlower", "Lnet/minecraft/util/math/BlockPos;", "getRandomOffset", "", "moveToNextTarget", "", "resetTask", "startExecuting", "updateTask", "future-mc"})
public final class PollinateAI
extends PassiveAI {
    private int lastPollinationTicks;
    private int pollinationTicks;
    private Vec3d nextTarget;
    private int ticks;
    private boolean isRunning;

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    @Override
    public boolean canBeeStart() {
        boolean bl;
        if (this.getBee().getFindFlowerCooldown() > 0) {
            return false;
        }
        if (this.getBee().hasNectar()) {
            return false;
        }
        World world = this.getBee().field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"bee.world");
        if (world.func_72896_J()) {
            return false;
        }
        if (this.getBee().func_70681_au().nextFloat() < 0.7f) {
            return false;
        }
        BlockPos flower = this.getFlower();
        if (flower != null) {
            this.getBee().setFlowerPos(flower);
            this.getBee().func_70661_as().func_75492_a((double)flower.func_177958_n() + 0.5, (double)flower.func_177956_o() + 0.5, (double)flower.func_177952_p() + 0.5, 1.2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canBeeContinue() {
        if (!this.isRunning) {
            return false;
        }
        if (!this.getBee().hasFlower()) {
            return false;
        }
        World world = this.getBee().field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"bee.world");
        if (world.func_72896_J()) {
            return false;
        }
        if (this.completedPollination()) {
            if (!(this.getBee().func_70681_au().nextFloat() < 0.2f)) return false;
            return true;
        }
        if (this.getBee().field_70173_aa % 20 != 0) return true;
        BeeEntity beeEntity = this.getBee();
        BlockPos blockPos = this.getBee().getFlowerPos();
        if (blockPos == null) {
            Intrinsics.throwNpe();
        }
        if (beeEntity.doesFlowerExist(blockPos)) return true;
        this.getBee().setFlowerPos(null);
        return false;
    }

    private final boolean completedPollination() {
        return this.pollinationTicks > 400;
    }

    public void func_75249_e() {
        this.getBee().resetPollinationTicks();
        this.pollinationTicks = 0;
        this.lastPollinationTicks = 0;
        this.ticks = 0;
        this.isRunning = true;
    }

    public void func_75251_c() {
        if (this.completedPollination()) {
            this.getBee().setHasNectar(true);
        }
        this.isRunning = false;
        this.getBee().func_70661_as().func_75499_g();
        this.getBee().setFindFlowerCooldown(200);
    }

    public void func_75246_d() {
        PollinateAI pollinateAI = this;
        ++pollinateAI.ticks;
        if (pollinateAI.ticks > 600) {
            this.getBee().setFlowerPos(null);
        } else {
            Vec3d v3c;
            BlockPos blockPos = this.getBee().getFlowerPos();
            if (blockPos == null) {
                Intrinsics.throwNpe();
            }
            if ((v3c = new Vec3d((Vec3i)blockPos).func_72441_c(0.5, 0.6, 0.5)).func_72438_d(this.getBee().func_174791_d()) > 1.0) {
                this.nextTarget = v3c;
                this.moveToNextTarget();
            } else {
                if (this.nextTarget == null) {
                    this.nextTarget = v3c;
                }
                boolean flag = this.getBee().func_174791_d().func_72438_d(v3c) <= 0.1;
                boolean flag1 = true;
                if (!flag && this.ticks > 600) {
                    this.getBee().setFlowerPos(null);
                } else {
                    if (flag) {
                        if (this.getBee().func_70681_au().nextInt(100) == 0) {
                            this.nextTarget = v3c.func_72441_c(this.getRandomOffset(), 0.0, this.getRandomOffset());
                            this.getBee().func_70661_as().func_75499_g();
                        } else {
                            flag1 = false;
                        }
                        this.getBee().field_70749_g.func_75650_a(v3c.field_72450_a, v3c.field_72448_b, v3c.field_72449_c, 10.0f, 40.0f);
                    }
                    if (flag1) {
                        this.moveToNextTarget();
                    }
                    PollinateAI pollinateAI2 = this;
                    ++pollinateAI2.pollinationTicks;
                    int cfr_ignored_0 = pollinateAI2.pollinationTicks;
                    if (this.getBee().func_70681_au().nextFloat() < 0.05f && this.pollinationTicks > this.lastPollinationTicks + 60) {
                        this.lastPollinationTicks = this.pollinationTicks;
                        this.getBee().func_184185_a(FSounds.BEE_POLLINATE, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private final void moveToNextTarget() {
        Vec3d vec3d = this.nextTarget;
        if (vec3d == null) {
            return;
        }
        Vec3d target = vec3d;
        this.getBee().func_70605_aq().func_75642_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, (double)0.35f);
    }

    private final double getRandomOffset() {
        return (this.getBee().func_70681_au().nextFloat() * 2.0f - 1.0f) * 0.33333334f;
    }

    private final BlockPos getFlower() {
        return this.getBee().getBlockInRange(5, (Function1<? super BlockPos, Boolean>)((Function1)new Function1<BlockPos, Boolean>(this){
            final /* synthetic */ PollinateAI this$0;

            public final boolean invoke(@NotNull BlockPos pos) {
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                BeeEntity beeEntity = this.this$0.getBee();
                IBlockState iBlockState = this.this$0.getBee().field_70170_p.func_180495_p(pos);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"bee.world.getBlockState(pos)");
                return beeEntity.isFlowerValid(iBlockState);
            }
            {
                this.this$0 = pollinateAI;
                super(1);
            }
        }));
    }

    public PollinateAI(@NotNull BeeEntity bee) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)bee), (String)"bee");
        super(bee);
        this.func_75248_a(1);
    }
}

