/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.panda;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.registry.FItems;
import thedarkcolour.futuremc.registry.FSounds;

public class EntityPanda
extends EntityAnimal {
    private static final DataParameter<Integer> HUNGRY_TICKS = EntityDataManager.func_187226_a(EntityPanda.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SNEEZE_TICKS = EntityDataManager.func_187226_a(EntityPanda.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> EATING_TICKS = EntityDataManager.func_187226_a(EntityPanda.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> MAIN_GENE = EntityDataManager.func_187226_a(EntityPanda.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> HIDDEN_GENE = EntityDataManager.func_187226_a(EntityPanda.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PANDA_FLAGS = EntityDataManager.func_187226_a(EntityPanda.class, (DataSerializer)DataSerializers.field_187191_a);
    private boolean revenge;
    private boolean attacked;
    public int field_213608_bz;
    private Vec3d field_213600_bJ;
    private float scaredAnimationProgress;
    private float lastScaredAnimationProgress;
    private float lazyProgress;
    private float lastLazyProgress;
    private float rollingProgress;
    private float lastRollingProgress;
    private static final Predicate<EntityItem> BREEDING_ITEM = entityItem -> {
        Item item = entityItem.func_92059_d().func_77973_b();
        return (item == FItems.INSTANCE.getBAMBOO() || item == Item.func_150898_a((Block)Blocks.field_150414_aQ)) && entityItem.func_70089_S() && !entityItem.func_174874_s();
    };

    public EntityPanda(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.25f, 1.25f);
        this.field_70765_h = new MoveHelperController(this);
    }

    public int getHungryTicks() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGRY_TICKS);
    }

    public void setHungryTicks(int hungryTicks) {
        this.field_70180_af.func_187227_b(HUNGRY_TICKS, (Object)hungryTicks);
    }

    public boolean isSneezing() {
        return this.getPandaFlag(2);
    }

    public boolean isSitting() {
        return this.getPandaFlag(8);
    }

    public void setIsScared(boolean flag) {
        this.setPandaFlag(8, flag);
    }

    public boolean isLazing() {
        return this.getPandaFlag(16);
    }

    public void func_213542_s(boolean p_213542_1_) {
        this.setPandaFlag(16, p_213542_1_);
    }

    public boolean isEating() {
        return (Integer)this.field_70180_af.func_187225_a(EATING_TICKS) > 0;
    }

    public void setIsEating(boolean p_213534_1_) {
        this.field_70180_af.func_187227_b(EATING_TICKS, (Object)(p_213534_1_ ? 1 : 0));
    }

    private int getEatingTicks() {
        return (Integer)this.field_70180_af.func_187225_a(EATING_TICKS);
    }

    private void setEatingTicks(int p_213571_1_) {
        this.field_70180_af.func_187227_b(EATING_TICKS, (Object)p_213571_1_);
    }

    public void func_213581_u(boolean flag) {
        this.setPandaFlag(2, flag);
        if (!flag) {
            this.setSneezeTicks(0);
        }
    }

    public int getSneezeTicks() {
        return (Integer)this.field_70180_af.func_187225_a(SNEEZE_TICKS);
    }

    public void setSneezeTicks(int ticks) {
        this.field_70180_af.func_187227_b(SNEEZE_TICKS, (Object)ticks);
    }

    public Type getMainGene() {
        return Type.fromID(((Byte)this.field_70180_af.func_187225_a(MAIN_GENE)).byteValue());
    }

    public void setMainGene(Type type) {
        if (type.getID() > 6) {
            type = Type.getRandomType(this.field_70146_Z);
        }
        this.field_70180_af.func_187227_b(MAIN_GENE, (Object)((byte)type.getID()));
    }

    public Type getHiddenGene() {
        return Type.fromID(((Byte)this.field_70180_af.func_187225_a(HIDDEN_GENE)).byteValue());
    }

    public void setHiddenGene(Type type) {
        if (type.getID() > 6) {
            type = Type.getRandomType(this.field_70146_Z);
        }
        this.field_70180_af.func_187227_b(HIDDEN_GENE, (Object)((byte)type.getID()));
    }

    public boolean isRolling() {
        return this.getPandaFlag(4);
    }

    public void setRolling(boolean isRolling) {
        this.setPandaFlag(4, isRolling);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HUNGRY_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(SNEEZE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(MAIN_GENE, (Object)0);
        this.field_70180_af.func_187214_a(HIDDEN_GENE, (Object)0);
        this.field_70180_af.func_187214_a(PANDA_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(EATING_TICKS, (Object)0);
    }

    private boolean getPandaFlag(int i2) {
        return ((Byte)this.field_70180_af.func_187225_a(PANDA_FLAGS) & i2) != 0;
    }

    private void setPandaFlag(int bit, boolean flag) {
        byte b = (Byte)this.field_70180_af.func_187225_a(PANDA_FLAGS);
        if (flag) {
            this.field_70180_af.func_187227_b(PANDA_FLAGS, (Object)((byte)(b | bit)));
        } else {
            this.field_70180_af.func_187227_b(PANDA_FLAGS, (Object)((byte)(b & ~bit)));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("MainGene", this.getMainGene().getName());
        compound.func_74778_a("HiddenGene", this.getHiddenGene().getName());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setMainGene(Type.fromName(compound.func_74779_i("MainGene")));
        this.setHiddenGene(Type.fromName(compound.func_74779_i("HiddenGene")));
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityPanda EntityPanda2 = new EntityPanda(this.field_70170_p);
        if (ageable instanceof EntityPanda) {
            EntityPanda2.func_213545_a(this, (EntityPanda)ageable);
        }
        EntityPanda2.adjustTraits();
        return EntityPanda2;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new PanicGoal(this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttack(this, 1.2f, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, (Item)FItems.INSTANCE.getBAMBOO(), false));
        this.field_70714_bg.func_75776_a(6, new EntityAIAvoid(this, EntityPlayer.class, 8.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(6, new EntityAIAvoid(this, EntityMob.class, 4.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAISit(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILieDown(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIChildPlay(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatch(this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new AIRoll(this));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIRevenge(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    public Type getPandaType() {
        return Type.func_221101_b(this.getMainGene(), this.getHiddenGene());
    }

    public boolean isLazy() {
        return this.getPandaType() == Type.LAZY;
    }

    public boolean isWorried() {
        return this.getPandaType() == Type.WORRIED;
    }

    public boolean isPlayful() {
        return this.getPandaType() == Type.PLAYFUL;
    }

    public boolean isWeak() {
        return this.getPandaType() == Type.WEAK;
    }

    public boolean isAggressive() {
        return this.getPandaType() == Type.AGGRESSIVE;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        this.func_184185_a(FSounds.INSTANCE.getPANDA_BITE(), 1.0f, 1.0f);
        if (!this.isAggressive()) {
            this.attacked = true;
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70071_h_() {
        try {
            super.func_70071_h_();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.isWorried()) {
            if (this.field_70170_p.func_72911_I() && !this.func_70090_H()) {
                this.setIsScared(true);
                this.setIsEating(false);
            } else if (!this.isEating()) {
                this.setIsScared(false);
            }
        }
        if (this.func_70638_az() == null) {
            this.revenge = false;
            this.attacked = false;
        }
        if (this.getHungryTicks() > 0) {
            if (this.func_70638_az() != null) {
                this.func_70625_a((Entity)this.func_70638_az(), 90.0f, 90.0f);
            }
            if (this.getHungryTicks() == 29 || this.getHungryTicks() == 14) {
                this.func_184185_a(FSounds.INSTANCE.getPANDA_CANNOT_BREED(), 1.0f, 1.0f);
            }
            this.setHungryTicks(this.getHungryTicks() - 1);
        }
        if (this.isSneezing()) {
            this.setSneezeTicks(this.getSneezeTicks() + 1);
            if (this.getSneezeTicks() > 20) {
                this.func_213581_u(false);
                this.sneeze();
            } else if (this.getSneezeTicks() == 1) {
                this.func_184185_a(FSounds.INSTANCE.getPANDA_PRE_SNEEZE(), 1.0f, 1.0f);
            }
        }
        if (this.isRolling()) {
            try {
                this.func_213535_ey();
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        } else {
            this.field_213608_bz = 0;
        }
        if (this.isSitting()) {
            this.field_70125_A = 0.0f;
        }
        this.updateScaredAnimation();
        this.updateEatingAnimation();
        this.updateLazyAnimation();
        this.updateRollingAnimation();
    }

    public boolean isFrightened() {
        return this.isWorried() && this.field_70170_p.func_72911_I();
    }

    private void updateEatingAnimation() {
        if (!this.isEating() && this.isSitting() && !this.isFrightened() && !this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && this.field_70146_Z.nextInt(80) == 1) {
            this.setIsEating(true);
        } else if (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() || !this.isSitting()) {
            this.setIsEating(false);
        }
        if (this.isEating()) {
            this.playEatingAnimation();
            if (!this.field_70170_p.field_72995_K && this.getEatingTicks() > 80 && this.field_70146_Z.nextInt(20) == 1) {
                if (this.getEatingTicks() > 100 && this.func_213548_j(this.func_184582_a(EntityEquipmentSlot.MAINHAND))) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    }
                    this.setIsScared(false);
                }
                this.setIsEating(false);
                return;
            }
            this.setEatingTicks(this.getEatingTicks() + 1);
        }
    }

    private void playEatingAnimation() {
        if (this.getEatingTicks() % 5 == 0) {
            this.func_184185_a(FSounds.INSTANCE.getPANDA_EAT(), 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            for (int i2 = 0; i2 < 6; ++i2) {
                Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1);
                vec3d = vec3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                vec3d = vec3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
                Vec3d vec3d1 = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.8, d0, 1.0 + ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.4);
                vec3d1 = vec3d1.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 1.0, this.field_70161_v);
                this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b())});
            }
        }
    }

    private void updateScaredAnimation() {
        this.lastScaredAnimationProgress = this.scaredAnimationProgress;
        this.scaredAnimationProgress = this.isSitting() ? Math.min(1.0f, this.scaredAnimationProgress + 0.15f) : Math.max(0.0f, this.scaredAnimationProgress - 0.19f);
    }

    private void updateLazyAnimation() {
        this.lastLazyProgress = this.lazyProgress;
        this.lazyProgress = this.isLazing() ? Math.min(1.0f, this.lazyProgress + 0.15f) : Math.max(0.0f, this.lazyProgress - 0.19f);
    }

    private void updateRollingAnimation() {
        this.lastRollingProgress = this.rollingProgress;
        this.rollingProgress = this.isRolling() ? Math.min(1.0f, this.rollingProgress + 0.15f) : Math.max(0.0f, this.rollingProgress - 0.19f);
    }

    public float func_213561_v(float p_213561_1_) {
        return EntityPanda.func_219799_g(p_213561_1_, this.lastScaredAnimationProgress, this.scaredAnimationProgress);
    }

    public float func_213583_w(float p_213583_1_) {
        return EntityPanda.func_219799_g(p_213583_1_, this.lastLazyProgress, this.lazyProgress);
    }

    public float func_213591_x(float p_213591_1_) {
        return EntityPanda.func_219799_g(p_213591_1_, this.lastRollingProgress, this.rollingProgress);
    }

    private void func_213535_ey() {
        ++this.field_213608_bz;
        if (this.field_213608_bz > 32) {
            this.setRolling(false);
        } else if (!this.field_70170_p.field_72995_K) {
            Vec3d vec3d = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_213608_bz == 1) {
                float f = this.field_70177_z * ((float)Math.PI / 180);
                float f1 = this.func_70631_g_() ? 0.1f : 0.2f;
                this.field_213600_bJ = new Vec3d(vec3d.field_72450_a + (double)(-MathHelper.func_76126_a((float)f) * f1), 0.0, vec3d.field_72449_c + (double)(MathHelper.func_76134_b((float)f) * f1));
                Vec3d vec = this.field_213600_bJ.func_72441_c(0.0, 0.27, 0.0);
                this.func_70016_h(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            } else if ((float)this.field_213608_bz != 7.0f && (float)this.field_213608_bz != 15.0f && (float)this.field_213608_bz != 23.0f) {
                this.func_70016_h(this.field_213600_bJ.field_72450_a, vec3d.field_72448_b, this.field_213600_bJ.field_72449_c);
            } else {
                this.func_70016_h(0.0, this.field_70122_E ? 0.27 : vec3d.field_72448_b, 0.0);
            }
        }
    }

    private void sneeze() {
        this.func_184185_a(FSounds.INSTANCE.getPANDA_SNEEZE(), 1.0f, 1.0f);
        for (EntityPanda entityPanda : this.field_70170_p.func_72872_a(EntityPanda.class, this.func_174813_aQ().func_186662_g(10.0))) {
            if (entityPanda.func_70631_g_() || !entityPanda.field_70122_E || entityPanda.func_70090_H() || !entityPanda.isOccupied()) continue;
            entityPanda.func_70664_aZ();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(700) == 0 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            this.func_70099_a(new ItemStack(Items.field_151123_aH), 0.0f);
        }
    }

    protected void func_175445_a(EntityItem itemEntity) {
        if (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && BREEDING_ITEM.test(itemEntity)) {
            ItemStack itemstack = itemEntity.func_92059_d();
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
            this.field_82174_bp[EntityEquipmentSlot.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.setIsScared(false);
        return super.func_70097_a(source, amount);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        data = super.func_180482_a(difficulty, data);
        this.setMainGene(Type.getRandomType(this.field_70146_Z));
        this.setHiddenGene(Type.getRandomType(this.field_70146_Z));
        this.modifyAttributes();
        if (data instanceof PandaData) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.func_70873_a(-24000);
            }
        } else {
            data = new PandaData();
        }
        return data;
    }

    private void func_213545_a(EntityPanda entityPanda, EntityPanda ageable) {
        if (ageable == null) {
            if (this.field_70146_Z.nextBoolean()) {
                this.setMainGene(entityPanda.pickMainOrHiddenGene());
                this.setHiddenGene(Type.getRandomType(this.field_70146_Z));
            } else {
                this.setMainGene(Type.getRandomType(this.field_70146_Z));
                this.setHiddenGene(entityPanda.pickMainOrHiddenGene());
            }
        } else if (this.field_70146_Z.nextBoolean()) {
            this.setMainGene(entityPanda.pickMainOrHiddenGene());
            this.setHiddenGene(ageable.pickMainOrHiddenGene());
        } else {
            this.setMainGene(ageable.pickMainOrHiddenGene());
            this.setHiddenGene(entityPanda.pickMainOrHiddenGene());
        }
        if (this.field_70146_Z.nextInt(32) == 0) {
            this.setMainGene(Type.getRandomType(this.field_70146_Z));
        }
        if (this.field_70146_Z.nextInt(32) == 0) {
            this.setHiddenGene(Type.getRandomType(this.field_70146_Z));
        }
    }

    private Type pickMainOrHiddenGene() {
        return this.field_70146_Z.nextBoolean() ? this.getMainGene() : this.getHiddenGene();
    }

    public void modifyAttributes() {
        if (this.isWeak()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        if (this.isLazy()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.07f);
        }
    }

    private void func_213586_eB() {
        if (!this.func_70090_H()) {
            this.func_191989_p(0.0f);
            this.func_70661_as().func_75499_g();
            this.setIsScared(true);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() instanceof ItemMonsterPlacer) {
            return super.func_184645_a(player, hand);
        }
        if (this.isFrightened()) {
            return false;
        }
        if (this.isLazing()) {
            this.func_213542_s(false);
            return true;
        }
        if (this.func_70877_b(itemstack)) {
            if (this.func_70638_az() != null) {
                this.revenge = true;
            }
            if (this.func_70631_g_()) {
                this.func_175505_a(player, itemstack);
                this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
            } else if (!this.field_70170_p.field_72995_K && this.func_70874_b() == 0 && this.canBreed()) {
                this.func_175505_a(player, itemstack);
                this.func_146082_f(player);
            } else {
                if (this.field_70170_p.field_72995_K || this.isSitting() || this.func_70090_H()) {
                    return false;
                }
                this.func_213586_eB();
                this.setIsEating(true);
                ItemStack stack = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
                if (!stack.func_190926_b() && !player.func_184812_l_()) {
                    this.func_70099_a(stack, 0.0f);
                }
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(itemstack.func_77973_b(), 1));
                this.func_175505_a(player, itemstack);
            }
            return true;
        }
        return false;
    }

    private boolean canBreed() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        if (this.isAggressive()) {
            return FSounds.INSTANCE.getPANDA_AGGRESSIVE_AMBIENT();
        }
        return this.isWorried() ? FSounds.INSTANCE.getPANDA_WORRIED_AMBIENT() : FSounds.INSTANCE.getPANDA_AMBIENT();
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(FSounds.INSTANCE.getPANDA_STEP(), 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == FItems.INSTANCE.getBAMBOO();
    }

    private boolean func_213548_j(ItemStack p_213548_1_) {
        return this.func_70877_b(p_213548_1_) || p_213548_1_.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150414_aQ);
    }

    protected SoundEvent func_184615_bR() {
        return FSounds.INSTANCE.getPANDA_DEATH();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FSounds.INSTANCE.getPANDA_HURT();
    }

    public boolean isOccupied() {
        return !this.isLazing() && !this.isFrightened() && !this.isEating() && !this.isRolling() && !this.isSitting();
    }

    public void adjustTraits() {
        if (this.isWeak()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        if (this.isLazy()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.07f);
        }
    }

    public static float func_219799_g(float p_219799_0_, float p_219799_1_, float p_219799_2_) {
        return p_219799_1_ + p_219799_0_ * (p_219799_2_ - p_219799_1_);
    }

    static class EntityAIWatch
    extends EntityAIWatchClosest {
        private final EntityPanda panda;

        EntityAIWatch(EntityPanda entityPanda, Class<? extends EntityLivingBase> targetEntity, float maxDistance) {
            super((EntityLiving)entityPanda, targetEntity, maxDistance);
            this.panda = entityPanda;
        }

        public boolean func_75250_a() {
            return this.panda.isOccupied() && super.func_75250_a();
        }
    }

    public static enum Type {
        NORMAL(0, "normal", false),
        LAZY(1, "lazy", false),
        WORRIED(2, "worried", false),
        PLAYFUL(3, "playful", false),
        BROWN(4, "brown", true),
        WEAK(5, "weak", true),
        AGGRESSIVE(6, "aggressive", false);

        private static final Type[] orderedTypes;
        private final int id;
        private final String name;
        private final boolean isRare;

        private Type(int id, String name, boolean p_i51468_5_) {
            this.id = id;
            this.name = name;
            this.isRare = p_i51468_5_;
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRare() {
            return this.isRare;
        }

        private static Type func_221101_b(Type main, Type hidden) {
            if (main.isRare()) {
                return main == hidden ? main : NORMAL;
            }
            return main;
        }

        public static Type fromID(int id) {
            if (id < 0 || id >= orderedTypes.length) {
                id = 0;
            }
            return orderedTypes[id];
        }

        public static Type fromName(String name) {
            for (Type pandaType : Type.values()) {
                if (!pandaType.name.equals(name)) continue;
                return pandaType;
            }
            return NORMAL;
        }

        public static Type getRandomType(Random random) {
            int i2 = random.nextInt(16);
            if (i2 == 0) {
                return LAZY;
            }
            if (i2 == 1) {
                return WORRIED;
            }
            if (i2 == 2) {
                return PLAYFUL;
            }
            if (i2 == 4) {
                return AGGRESSIVE;
            }
            if (i2 < 9) {
                return WEAK;
            }
            return i2 < 11 ? BROWN : NORMAL;
        }

        static {
            orderedTypes = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::getID)).toArray(Type[]::new);
        }
    }

    private static class EntityAISit
    extends EntityAIBase {
        private final EntityPanda panda;
        private int field_220832_b;

        private EntityAISit(EntityPanda panda) {
            this.func_75248_a(1);
            this.panda = panda;
        }

        public boolean func_75250_a() {
            if (this.field_220832_b <= this.panda.field_70173_aa && !this.panda.func_70631_g_() && !this.panda.func_70090_H() && this.panda.isOccupied() && this.panda.getHungryTicks() <= 0) {
                List list2 = this.panda.field_70170_p.func_175647_a(EntityItem.class, this.panda.func_174813_aQ().func_72314_b(6.0, 6.0, 6.0), BREEDING_ITEM::test);
                return !list2.isEmpty() || !this.panda.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b();
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!this.panda.func_70090_H() && (this.panda.isLazy() || this.panda.field_70146_Z.nextInt(600) != 1)) {
                return this.panda.field_70146_Z.nextInt(2000) != 1;
            }
            return false;
        }

        public void func_75246_d() {
            if (!this.panda.isSitting() && !this.panda.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                this.panda.func_213586_eB();
            }
        }

        public void func_75249_e() {
            List list2 = this.panda.field_70170_p.func_175647_a(EntityItem.class, this.panda.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), BREEDING_ITEM::test);
            if (!list2.isEmpty() && this.panda.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                this.panda.func_70661_as().func_75497_a((Entity)list2.get(0), (double)1.2f);
            } else if (!this.panda.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                this.panda.func_213586_eB();
            }
            this.field_220832_b = 0;
        }

        public void func_75251_c() {
            ItemStack itemstack = this.panda.func_184582_a(EntityEquipmentSlot.MAINHAND);
            if (!itemstack.func_190926_b()) {
                this.panda.func_70099_a(itemstack, 0.0f);
                this.panda.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                int i2 = this.panda.isLazy() ? this.panda.field_70146_Z.nextInt(50) + 10 : this.panda.field_70146_Z.nextInt(150) + 10;
                this.field_220832_b = this.panda.field_70173_aa + i2 * 20;
            }
            this.panda.setIsScared(false);
        }
    }

    private static class AIRoll
    extends EntityAIBase {
        private final EntityPanda panda;

        private AIRoll(EntityPanda panda) {
            this.panda = panda;
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            if ((this.panda.func_70631_g_() || this.panda.isPlayful()) && this.panda.field_70122_E) {
                BlockPos pos;
                IBlockState state;
                if (!this.panda.isOccupied()) {
                    return false;
                }
                float f = this.panda.field_70177_z * ((float)Math.PI / 180);
                int i2 = 0;
                int j = 0;
                float f1 = -MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                if ((double)Math.abs(f1) > 0.5) {
                    i2 = (int)((float)i2 + f1 / Math.abs(f1));
                }
                if ((double)Math.abs(f2) > 0.5) {
                    j = (int)((float)j + f2 / Math.abs(f2));
                }
                if ((state = this.panda.field_70170_p.func_180495_p(pos = new BlockPos(this.panda.field_70165_t + (double)i2, this.panda.field_70163_u - 1.0, this.panda.field_70161_v + (double)j))).func_185904_a() == Material.field_151579_a) {
                    return true;
                }
                if (this.panda.isPlayful() && this.panda.field_70146_Z.nextInt(60) == 1) {
                    return true;
                }
                return this.panda.field_70146_Z.nextInt(500) == 1;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.panda.setRolling(true);
        }

        public boolean func_75252_g() {
            return false;
        }
    }

    private static class AIRevenge
    extends EntityAIHurtByTarget {
        private final EntityPanda panda;

        private AIRevenge(EntityPanda entityPanda) {
            super((EntityCreature)entityPanda, true, new Class[0]);
            this.panda = entityPanda;
        }

        public boolean func_75253_b() {
            if (!this.panda.revenge && !this.panda.attacked) {
                return super.func_75253_b();
            }
            this.panda.func_70624_b(null);
            return false;
        }
    }

    static class PanicGoal
    extends EntityAIPanic {
        private final EntityPanda field_220740_f;

        PanicGoal(EntityPanda entityPanda, double speedIn) {
            super((EntityCreature)entityPanda, speedIn);
            this.field_220740_f = entityPanda;
        }

        public boolean func_75250_a() {
            if (!this.field_220740_f.func_70027_ad()) {
                return false;
            }
            BlockPos blockpos = this.getRandomPos(this.field_220740_f.field_70170_p, this.field_220740_f);
            if (blockpos != null) {
                this.field_75266_c = blockpos.func_177958_n();
                this.field_75263_d = blockpos.func_177956_o();
                this.field_75264_e = blockpos.func_177952_p();
                return true;
            }
            return this.func_190863_f();
        }

        public boolean func_75253_b() {
            if (this.field_220740_f.isSitting()) {
                this.field_220740_f.func_70661_as().func_75499_g();
                return false;
            }
            return super.func_75253_b();
        }

        private BlockPos getRandomPos(World worldIn, EntityPanda entityPanda) {
            BlockPos pos = new BlockPos((Entity)entityPanda);
            int i2 = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 200.0f;
            BlockPos pos1 = null;
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int l = i2 - 5; l <= i2 + 5; ++l) {
                for (int i1 = j - 4; i1 <= j + 4; ++i1) {
                    for (int j1 = k - 5; j1 <= k + 5; ++j1) {
                        float f1;
                        mutablePos.func_181079_c(l, i1, j1);
                        IBlockState iblockstate = worldIn.func_180495_p((BlockPos)mutablePos);
                        if (iblockstate.func_185904_a() != Material.field_151586_h || !((f1 = (float)((l - i2) * (l - i2) + (i1 - j) * (i1 - j) + (j1 - k) * (j1 - k))) < f)) continue;
                        f = f1;
                        pos1 = new BlockPos((Vec3i)mutablePos);
                    }
                }
            }
            return pos1;
        }
    }

    private static class PandaData
    implements IEntityLivingData {
        private PandaData() {
        }
    }

    private static class MoveHelperController
    extends EntityMoveHelper {
        private final EntityPanda panda;

        private MoveHelperController(EntityPanda panda) {
            super((EntityLiving)panda);
            this.panda = panda;
        }

        public void func_75641_c() {
            if (this.panda.isOccupied()) {
                super.func_75641_c();
            }
        }
    }

    private static class AIMate
    extends EntityAIMate {
        private final EntityPanda panda;
        private int field_220694_f;

        private AIMate(EntityPanda entityPanda, double speedIn) {
            super((EntityAnimal)entityPanda, speedIn);
            this.panda = entityPanda;
        }

        public boolean func_75250_a() {
            if (super.func_75250_a() && this.panda.getHungryTicks() == 0) {
                if (!this.inRangeOfBamboo()) {
                    if (this.field_220694_f <= this.panda.field_70173_aa) {
                        this.panda.setHungryTicks(32);
                        this.field_220694_f = this.panda.field_70173_aa + 600;
                        if (this.panda.func_70613_aW()) {
                            EntityPlayer playerIn = this.panda.field_70170_p.func_190525_a(this.panda.field_70165_t, this.panda.field_70163_u, this.panda.field_70161_v, 8.0, EntitySelectors.field_180132_d);
                            this.panda.func_70624_b((EntityLivingBase)playerIn);
                        }
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean inRangeOfBamboo() {
            BlockPos pos = new BlockPos((Entity)this.panda);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int j = 0; j < 8; ++j) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutablePos.func_189533_g((Vec3i)pos).func_177982_a(k, i2, l);
                            if (this.panda.field_70170_p.func_180495_p((BlockPos)mutablePos).func_177230_c() == FBlocks.INSTANCE.getBAMBOO()) {
                                return true;
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                }
            }
            return false;
        }
    }

    private static class EntityAILieDown
    extends EntityAIBase {
        private final EntityPanda field_220828_a;
        private int field_220829_b;

        private EntityAILieDown(EntityPanda p_i51460_1_) {
            this.field_220828_a = p_i51460_1_;
        }

        public boolean func_75250_a() {
            return this.field_220829_b < this.field_220828_a.field_70173_aa && this.field_220828_a.isLazy() && this.field_220828_a.isOccupied() && this.field_220828_a.field_70146_Z.nextInt(400) == 1;
        }

        public boolean func_75253_b() {
            if (!this.field_220828_a.func_70090_H() && (this.field_220828_a.isLazy() || this.field_220828_a.field_70146_Z.nextInt(600) != 1)) {
                return this.field_220828_a.field_70146_Z.nextInt(2000) != 1;
            }
            return false;
        }

        public void func_75249_e() {
            this.field_220828_a.func_213542_s(true);
            this.field_220829_b = 0;
        }

        public void func_75251_c() {
            this.field_220828_a.func_213542_s(false);
            this.field_220829_b = this.field_220828_a.field_70173_aa + 200;
        }
    }

    private static class EntityAIChildPlay
    extends EntityAIBase {
        private final EntityPanda entityPanda;

        private EntityAIChildPlay(EntityPanda p_i51448_1_) {
            this.entityPanda = p_i51448_1_;
        }

        public boolean func_75250_a() {
            if (this.entityPanda.func_70631_g_() && this.entityPanda.isOccupied()) {
                if (this.entityPanda.isWeak() && this.entityPanda.field_70146_Z.nextInt(500) == 1) {
                    return true;
                }
                return this.entityPanda.field_70146_Z.nextInt(6000) == 1;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.entityPanda.func_213581_u(true);
        }
    }

    private static class EntityAIAvoid<T extends EntityLivingBase>
    extends EntityAIAvoidEntity<T> {
        private final EntityPanda field_220875_i;

        private EntityAIAvoid(EntityPanda entityPanda, Class<T> entityToAvoid, float avoidDistance, double farSpeedIn, double nearSpeedIn) {
            super((EntityCreature)entityPanda, entityToAvoid, entity -> {
                if (entity instanceof EntityPlayer) {
                    return !((EntityPlayer)entity).func_175149_v();
                }
                return true;
            }, avoidDistance, farSpeedIn, nearSpeedIn);
            this.field_220875_i = entityPanda;
        }

        public boolean func_75250_a() {
            return this.field_220875_i.isWorried() && this.field_220875_i.isOccupied() && super.func_75250_a();
        }
    }

    private static class EntityAIAttack
    extends EntityAIAttackMelee {
        private final EntityPanda entityPanda;

        private EntityAIAttack(EntityPanda entityPanda, double speedIn, boolean useLongMemory) {
            super((EntityCreature)entityPanda, speedIn, useLongMemory);
            this.entityPanda = entityPanda;
        }

        public boolean func_75250_a() {
            return this.entityPanda.isOccupied() && super.func_75250_a();
        }
    }
}

