/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.tile;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import thedarkcolour.core.inventory.DarkInventory;
import thedarkcolour.futuremc.block.villagepillage.BarrelBlock;
import thedarkcolour.futuremc.container.ContainerBarrel;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.registry.FSounds;

public class TileBarrel
extends TileEntity {
    private final DarkInventory inventory = new DarkInventory(27){

        @Override
        public void onContentsChanged(int slot) {
            TileBarrel.this.func_70296_d();
        }
    };
    private int numPlayersUsing;

    public void func_145839_a(NBTTagCompound compound) {
        String key;
        super.func_145839_a(compound);
        String string = key = compound.func_74764_b("item") ? "item" : "items";
        if (compound.func_74764_b(key)) {
            this.inventory.deserializeNBT(compound.func_74775_l(key));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public DarkInventory getInventory() {
        return this.inventory;
    }

    public void openForPlayer(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!((Boolean)state.func_177229_b((IProperty)BarrelBlock.OPEN)).booleanValue()) {
                this.playSound(state, FSounds.BLOCK_BARREL_OPEN);
                this.setOpen(true, state);
            }
            this.scheduleUpdate();
        }
    }

    public void setOpen(boolean open, IBlockState state) {
        state = FBlocks.BARREL.func_176223_P().func_177226_a((IProperty)BarrelBlock.FACING, state.func_177229_b((IProperty)BarrelBlock.FACING)).func_177226_a((IProperty)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(open));
        this.field_145850_b.func_175656_a(this.field_174879_c, state);
    }

    public void closeForPlayer(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
        }
    }

    public void updateOpenState() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        this.numPlayersUsing = this.calculatePlayersUsing(x, y, z);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.numPlayersUsing > 0) {
            this.scheduleUpdate();
        } else {
            if (state.func_177230_c() != FBlocks.BARREL) {
                this.func_145843_s();
                return;
            }
            boolean flag = (Boolean)state.func_177229_b((IProperty)BarrelBlock.OPEN);
            if (flag) {
                this.playSound(state, FSounds.BLOCK_BARREL_CLOSE);
                this.setOpen(false, state);
            }
        }
    }

    public void scheduleUpdate() {
        this.field_145850_b.func_175684_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), 5);
    }

    public void playSound(IBlockState state, SoundEvent event) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Vec3i vec = ((EnumFacing)state.func_177229_b((IProperty)BarrelBlock.FACING)).func_176730_m();
        double d0 = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)vec.func_177958_n() / 2.0;
        double d1 = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)vec.func_177956_o() / 2.0;
        double d2 = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)vec.func_177952_p() / 2.0;
        this.field_145850_b.func_184148_a(null, d0, d1, d2, event, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    private int calculatePlayersUsing(int x, int y, int z) {
        int i2 = 0;
        for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)x + 6.0f), (double)((float)y + 16.0f), (double)((float)z + 6.0f)))) {
            if (!(entityplayer.field_71070_bA instanceof ContainerBarrel)) continue;
            TileBarrel te = ((ContainerBarrel)entityplayer.field_71070_bA).te;
            if (te.field_174879_c != this.field_174879_c) continue;
            ++i2;
        }
        return i2;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

