/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.tile;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import thedarkcolour.futuremc.block.villagepillage.BlockFurnaceAdvanced;
import thedarkcolour.futuremc.container.ContainerFurnaceAdvanced;

public class TileFurnaceAdvanced
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 1};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private final BlockFurnaceAdvanced.FurnaceType type;
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private SidedInvWrapper handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private SidedInvWrapper handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private SidedInvWrapper handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileFurnaceAdvanced(BlockFurnaceAdvanced.FurnaceType type) {
        this.type = type;
    }

    public static void setState(boolean active, World world, BlockPos pos) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileFurnaceAdvanced) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)BlockFurnaceAdvanced.Companion.getLIT(), (Comparable)Boolean.valueOf(active)));
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.furnaceItemStacks);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.currentItemBurnTime = compound.func_74762_e("CurrentItemBurnTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.furnaceBurnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CurrentItemBurnTime", this.currentItemBurnTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.furnaceItemStacks);
        return compound;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            this.furnaceBurnTime -= 2;
            if (this.furnaceBurnTime < 0) {
                this.furnaceBurnTime = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(1);
            int totalCookTime = 100;
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.furnaceItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == totalCookTime) {
                        this.cookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                TileFurnaceAdvanced.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(0);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = (ItemStack)this.furnaceItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(1);
        return TileEntityFurnace.func_145954_b((ItemStack)stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    private boolean canSmelt() {
        if (!this.getType().canCraft((ItemStack)this.furnaceItemStacks.get(0))) {
            return false;
        }
        ItemStack itemstack = this.getType().getOutput((ItemStack)this.furnaceItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.furnaceItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                return;
            }
            case 1: {
                this.currentItemBurnTime = value;
                return;
            }
            case 2: {
                this.cookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.furnaceItemStacks.clear();
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && index == 1) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.furnaceItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFurnaceAdvanced(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "futuremc:" + this.getType().getType().toLowerCase();
    }

    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public BlockFurnaceAdvanced.FurnaceType getType() {
        return this.type;
    }

    public static class TileBlastFurnace
    extends TileFurnaceAdvanced {
        public TileBlastFurnace() {
            super(BlockFurnaceAdvanced.FurnaceType.BLAST_FURNACE);
        }
    }

    public static class TileSmoker
    extends TileFurnaceAdvanced {
        public TileSmoker() {
            super(BlockFurnaceAdvanced.FurnaceType.SMOKER);
        }
    }
}

