/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.world.gen.chunk;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import kotlin.KotlinPackage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.futuremc.world.biome.FBiome;
import thedarkcolour.futuremc.world.gen.CarvingStage;
import thedarkcolour.futuremc.world.gen.ConfiguredCarver;
import thedarkcolour.futuremc.world.gen.DecorationStage;
import thedarkcolour.futuremc.world.gen.WorldGenPreview;
import thedarkcolour.futuremc.world.gen.chunk.BiomeManager;
import thedarkcolour.futuremc.world.gen.chunk.BiomeMap;
import thedarkcolour.futuremc.world.gen.chunk.ChunkGenConfig;
import thedarkcolour.futuremc.world.gen.chunk.ChunkGenPreview;
import thedarkcolour.futuremc.world.gen.chunk.ChunkGenerator$sam$net_minecraft_crash_ICrashReportDetail$0;
import thedarkcolour.futuremc.world.gen.chunk.IChunk;
import thedarkcolour.futuremc.world.gen.structure.AbstractStructure;
import thedarkcolour.futuremc.world.gen.structure.IChunkPos;
import thedarkcolour.futuremc.world.gen.structure.WorldGenRandom;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J0\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020.2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020$H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\n\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lthedarkcolour/futuremc/world/gen/chunk/ChunkGenerator;", "T", "Lthedarkcolour/futuremc/world/gen/chunk/ChunkGenConfig;", "Lnet/minecraft/world/gen/IChunkGenerator;", "world", "Lnet/minecraft/world/World;", "seed", "", "biomeProvider", "Lnet/minecraft/world/biome/BiomeProvider;", "config", "(Lnet/minecraft/world/World;JLnet/minecraft/world/biome/BiomeProvider;Lthedarkcolour/futuremc/world/gen/chunk/ChunkGenConfig;)V", "getBiomeProvider", "()Lnet/minecraft/world/biome/BiomeProvider;", "getConfig", "()Lthedarkcolour/futuremc/world/gen/chunk/ChunkGenConfig;", "Lthedarkcolour/futuremc/world/gen/chunk/ChunkGenConfig;", "getSeed", "()J", "getWorld", "()Lnet/minecraft/world/World;", "carve", "", "manager", "Lthedarkcolour/futuremc/world/gen/chunk/BiomeManager;", "chunk", "Lthedarkcolour/futuremc/world/gen/chunk/IChunk;", "stage", "Lthedarkcolour/futuremc/world/gen/CarvingStage;", "decorate", "preview", "Lthedarkcolour/futuremc/world/gen/WorldGenPreview;", "fillBiomeMap", "chunkPreview", "Lthedarkcolour/futuremc/world/gen/chunk/ChunkGenPreview;", "findNearestStructure", "Lnet/minecraft/util/math/BlockPos;", "worldIn", "name", "", "pos", "radius", "", "skipExistingChunks", "", "getBiome", "Lthedarkcolour/futuremc/world/biome/FBiome;", "future-mc"})
public abstract class ChunkGenerator<T extends ChunkGenConfig>
implements IChunkGenerator {
    @NotNull
    private final World world;
    private final long seed;
    @NotNull
    private final BiomeProvider biomeProvider;
    @NotNull
    private final T config;

    public final void fillBiomeMap(@NotNull ChunkGenPreview chunkPreview) {
        Intrinsics.checkParameterIsNotNull((Object)chunkPreview, (String)"chunkPreview");
        chunkPreview.setBiomeMap(new BiomeMap(chunkPreview.getPos(), this.biomeProvider, null));
    }

    @NotNull
    public FBiome getBiome(@NotNull BiomeManager manager, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return manager.getBiome(pos);
    }

    /*
     * WARNING - void declaration
     */
    public void carve(@NotNull BiomeManager manager, @NotNull IChunk chunk, @NotNull CarvingStage stage) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull((Object)((Object)stage), (String)"stage");
        WorldGenRandom rand = new WorldGenRandom();
        long chunkPos = chunk.getPos();
        int j = IChunkPos.getX-impl(chunkPos);
        int k = IChunkPos.getX-impl(chunkPos);
        FBiome biome = this.getBiome(manager, IChunkPos.toBlockPos-impl(chunkPos));
        BitSet mask = chunk.getCarvingMask();
        int n = j - 8;
        int n2 = j + 8;
        if (n <= n2) {
            while (true) {
                void l;
                int n3;
                int n4;
                if ((n4 = k - 8) <= (n3 = k + 8)) {
                    while (true) {
                        void i1;
                        List<ConfiguredCarver<?, ?>> list2 = biome.getCarvers(stage);
                        ListIterator<ConfiguredCarver<?, ?>> iterator = list2.listIterator();
                        while (iterator.hasNext()) {
                            int j1 = iterator.nextIndex();
                            ConfiguredCarver<?, ?> carver = iterator.next();
                            rand.setLargeFeatureSeed(this.seed + (long)j1, (int)l, (int)i1);
                            if (!carver.canCarve(rand, (int)l, (int)i1)) continue;
                            carver.carve(chunk, rand, this.world.func_181545_F(), (int)l, (int)i1, j, k, mask, (Function1<BlockPos, Biome>)((Function1)new Function1<BlockPos, FBiome>(this, manager){
                                final /* synthetic */ ChunkGenerator this$0;
                                final /* synthetic */ BiomeManager $manager;

                                @NotNull
                                public final FBiome invoke(@NotNull BlockPos pos) {
                                    Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                                    return this.this$0.getBiome(this.$manager, pos);
                                }
                                {
                                    this.this$0 = chunkGenerator;
                                    this.$manager = biomeManager;
                                    super(1);
                                }
                            }));
                        }
                        if (i1 == n3) break;
                        ++i1;
                    }
                }
                if (l == n2) break;
                ++l;
            }
        }
    }

    @Nullable
    public final BlockPos findNearestStructure(@NotNull World worldIn, @NotNull String name, @NotNull BlockPos pos, int radius, boolean skipExistingChunks) {
        AbstractStructure<?> structure;
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        AbstractStructure<?> abstractStructure = structure = AbstractStructure.Companion.getREGISTRY().get(name);
        return abstractStructure != null ? abstractStructure.findNearest(worldIn, this, pos, radius, skipExistingChunks) : null;
    }

    public final void decorate(@NotNull WorldGenPreview preview) {
        Intrinsics.checkParameterIsNotNull((Object)preview, (String)"preview");
        int i2 = preview.getMainX();
        int j = preview.getMainZ();
        int k = i2 * 16;
        int l = j * 16;
        BlockPos pos = new BlockPos(k, 0, l);
        BiomeManager biomeManager = preview.getBiomeManager();
        BlockPos blockPos = pos.func_177982_a(8, 8, 8);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.add(8, 8, 8)");
        FBiome biome = this.getBiome(biomeManager, blockPos);
        WorldGenRandom rand = new WorldGenRandom();
        long i1 = rand.setDecorationSeed(preview.getSeed(), k, l);
        for (DecorationStage stage : DecorationStage.values()) {
            try {
                biome.decorate(stage, this, preview, i1, rand, pos);
            }
            catch (Exception e) {
                CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)"Biome decoration");
                CrashReportCategory cat = report.func_85058_a("Generation");
                Function0 function0 = (Function0)new Function0<String>(i2){

                    @NotNull
                    public final String invoke() {
                        return String.valueOf(((Number)this.receiver).intValue());
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Integer.TYPE);
                    }

                    public final String getName() {
                        return "toString";
                    }

                    public final String getSignature() {
                        return "toString()Ljava/lang/String;";
                    }
                };
                cat.func_189529_a("CenterX", (ICrashReportDetail)new ChunkGenerator$sam$net_minecraft_crash_ICrashReportDetail$0(function0));
                function0 = (Function0)new Function0<String>(j){

                    @NotNull
                    public final String invoke() {
                        return String.valueOf(((Number)this.receiver).intValue());
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Integer.TYPE);
                    }

                    public final String getName() {
                        return "toString";
                    }

                    public final String getSignature() {
                        return "toString()Ljava/lang/String;";
                    }
                };
                cat.func_189529_a("CenterZ", (ICrashReportDetail)new ChunkGenerator$sam$net_minecraft_crash_ICrashReportDetail$0(function0));
                function0 = (Function0)new Function0<String>(stage){

                    @NotNull
                    public final String invoke() {
                        return ((DecorationStage)((Object)this.receiver)).toString();
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(DecorationStage.class);
                    }

                    public final String getName() {
                        return "toString";
                    }

                    public final String getSignature() {
                        return "toString()Ljava/lang/String;";
                    }
                };
                cat.func_189529_a("Stage", (ICrashReportDetail)new ChunkGenerator$sam$net_minecraft_crash_ICrashReportDetail$0(function0));
                function0 = (Function0)new Function0<String>(i1){

                    @NotNull
                    public final String invoke() {
                        return String.valueOf(((Number)this.receiver).longValue());
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Long.TYPE);
                    }

                    public final String getName() {
                        return "toString";
                    }

                    public final String getSignature() {
                        return "toString()Ljava/lang/String;";
                    }
                };
                cat.func_189529_a("Seed", (ICrashReportDetail)new ChunkGenerator$sam$net_minecraft_crash_ICrashReportDetail$0(function0));
                function0 = (Function0)new Function0<String>(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome)){

                    @NotNull
                    public final String invoke() {
                        return String.valueOf((ResourceLocation)this.receiver);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinPackage(KotlinPackage.class, (String)"future-mc");
                    }

                    public final String getName() {
                        return "toString";
                    }

                    public final String getSignature() {
                        return "toString(Ljava/lang/Object;)Ljava/lang/String;";
                    }
                };
                cat.func_189529_a("Biome", (ICrashReportDetail)new ChunkGenerator$sam$net_minecraft_crash_ICrashReportDetail$0(function0));
                throw (Throwable)new ReportedException(report);
            }
        }
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    protected final long getSeed() {
        return this.seed;
    }

    @NotNull
    public final BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    @NotNull
    protected final T getConfig() {
        return this.config;
    }

    public ChunkGenerator(@NotNull World world, long seed, @NotNull BiomeProvider biomeProvider, @NotNull T config) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)biomeProvider, (String)"biomeProvider");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        this.world = world;
        this.seed = seed;
        this.biomeProvider = biomeProvider;
        this.config = config;
    }
}

