/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.world.gen.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.BiomeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.futuremc.world.gen.config.IFeatureConfig;
import thedarkcolour.futuremc.world.gen.structure.AbstractStructure;
import thedarkcolour.futuremc.world.gen.structure.StructureStart;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J*\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0095\u0001\u0010\u001d\u001a\u008e\u0001\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0001\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(#\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(%\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020'0\u001ej\u0002`(H\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010.\u001a\u00020-H\u0002J8\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u0002012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00102\u001a\u0002032\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\u0006\u00104\u001a\u000205H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lthedarkcolour/futuremc/world/gen/structure/StrongholdStructure;", "Lthedarkcolour/futuremc/world/gen/structure/AbstractStructure;", "Lthedarkcolour/futuremc/world/gen/config/IFeatureConfig$Default;", "()V", "ranBiomeCheck", "", "seed", "", "structureCoords", "", "Lnet/minecraft/util/math/ChunkPos;", "[Lnet/minecraft/util/math/ChunkPos;", "structureName", "", "getStructureName", "()Ljava/lang/String;", "structureStarts", "Ljava/util/ArrayList;", "Lnet/minecraft/world/gen/structure/StructureStart;", "Lkotlin/collections/ArrayList;", "doesWorldHaveStronghold", "worldIn", "Lnet/minecraft/world/World;", "findNearest", "Lnet/minecraft/util/math/BlockPos;", "pos", "radius", "", "skipExisting", "getStartFactory", "Lkotlin/Function6;", "Lkotlin/ParameterName;", "name", "structure", "chunkX", "chunkZ", "Lnet/minecraft/world/gen/structure/StructureBoundingBox;", "bounds", "references", "Lthedarkcolour/futuremc/world/gen/structure/StructureStart;", "Lthedarkcolour/futuremc/world/gen/structure/IStartFactory;", "getStrongholdCount", "getStrongholdDistance", "", "reinitializeData", "", "resetData", "shouldStartAt", "manager", "Lnet/minecraftforge/common/BiomeManager;", "rand", "Ljava/util/Random;", "biome", "Lnet/minecraft/world/biome/Biome;", "future-mc"})
public final class StrongholdStructure
extends AbstractStructure<IFeatureConfig.Default> {
    private boolean ranBiomeCheck;
    private ChunkPos[] structureCoords;
    private final ArrayList<net.minecraft.world.gen.structure.StructureStart> structureStarts;
    private long seed;
    @NotNull
    private final String structureName = "Stronghold";

    @Override
    public boolean shouldStartAt(@NotNull BiomeManager manager, @NotNull World worldIn, @NotNull Random rand, int chunkX, int chunkZ, @NotNull Biome biome) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)biome, (String)"biome");
        if (this.seed != worldIn.func_72905_C()) {
            this.resetData();
        }
        if (!this.ranBiomeCheck) {
            this.reinitializeData(worldIn);
            this.ranBiomeCheck = true;
        }
        if (this.structureCoords == null) {
            Intrinsics.throwNpe();
        }
        for (ChunkPos chunkPos : this.structureCoords) {
            if (chunkX != chunkPos.field_77276_a || chunkZ != chunkPos.field_77275_b) continue;
            return true;
        }
        return false;
    }

    private final void resetData() {
        this.ranBiomeCheck = false;
        this.structureCoords = null;
        this.structureStarts.clear();
    }

    @Override
    @NotNull
    public Function6<AbstractStructure<?>, Integer, Integer, StructureBoundingBox, Integer, Long, StructureStart> getStartFactory() {
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public String getStructureName() {
        return this.structureName;
    }

    @Override
    @Nullable
    public BlockPos findNearest(@NotNull World worldIn, @NotNull BlockPos pos, int radius, boolean skipExisting) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (this.doesWorldHaveStronghold(worldIn)) {
            return null;
        }
        if (this.seed != worldIn.func_72905_C()) {
            this.resetData();
        }
        if (!this.ranBiomeCheck) {
            this.reinitializeData(worldIn);
            this.ranBiomeCheck = true;
        }
        BlockPos pos1 = null;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double d0 = DoubleCompanionObject.INSTANCE.getMAX_VALUE();
        if (this.structureCoords == null) {
            Intrinsics.throwNpe();
        }
        for (ChunkPos chunkPos : this.structureCoords) {
            mutable.func_181079_c((chunkPos.field_77276_a << 4) + 8, 32, (chunkPos.field_77275_b << 4) + 8);
            double d1 = mutable.func_177951_i((Vec3i)pos);
            if (pos1 == null) {
                pos1 = mutable.func_185334_h();
                d0 = d1;
                continue;
            }
            if (!(d1 < d0)) continue;
            pos1 = mutable.func_185334_h();
            d0 = d1;
        }
        return pos1;
    }

    private final void reinitializeData(World worldIn) {
        this.seed = worldIn.func_72905_C();
        boolean bl = false;
        HashSet allowedBiomes = new HashSet();
        double i2 = this.getStrongholdDistance(worldIn);
        double j2 = this.getStrongholdDistance(worldIn);
    }

    public final boolean doesWorldHaveStronghold(@NotNull World worldIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    private final double getStrongholdDistance(World worldIn) {
        double d;
        IChunkProvider provider = worldIn.func_72863_F();
        if (provider instanceof ChunkProviderServer) {
            IChunkGenerator generator = ((ChunkProviderServer)provider).field_186029_c;
            IChunkGenerator iChunkGenerator = generator;
            if (iChunkGenerator instanceof ChunkGeneratorOverworld) {
                double cfr_ignored_0 = ((ChunkGeneratorOverworld)generator).field_186004_w.field_82671_h;
            } else if (iChunkGenerator instanceof ChunkGeneratorFlat) {
                Iterable $this$firstOrNull$iv = ((ChunkGeneratorFlat)generator).field_82696_f.values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MapGenStructure it = (MapGenStructure)element$iv;
                    boolean bl = false;
                    if (!(it instanceof MapGenStronghold)) continue;
                    break;
                }
            }
            d = 32.0;
        } else {
            d = -1.0;
        }
        return d;
    }

    private final int getStrongholdCount(World worldIn) {
        int n;
        IChunkProvider provider = worldIn.func_72863_F();
        if (provider instanceof ChunkProviderServer) {
            IChunkGenerator generator = ((ChunkProviderServer)provider).field_186029_c;
            IChunkGenerator iChunkGenerator = generator;
            if (iChunkGenerator instanceof ChunkGeneratorOverworld) {
                int cfr_ignored_0 = ((ChunkGeneratorOverworld)generator).field_186004_w.field_75057_g.length;
            }
            n = 128;
        } else {
            n = 0;
        }
        return n;
    }

    public StrongholdStructure() {
        StrongholdStructure strongholdStructure = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        strongholdStructure.structureStarts = arrayList;
        this.structureName = "Stronghold";
    }
}

